import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone#name DataAzurermPrivateDnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone#resource_group_name DataAzurermPrivateDnsZone#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone#timeouts DataAzurermPrivateDnsZone#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsZoneTimeouts;
}
export interface DataAzurermPrivateDnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone#read DataAzurermPrivateDnsZone#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsZoneTimeoutsToTerraform(struct?: DataAzurermPrivateDnsZoneTimeoutsOutputReference | DataAzurermPrivateDnsZoneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPrivateDnsZoneTimeouts | undefined;
    set internalValue(value: DataAzurermPrivateDnsZoneTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone azurerm_private_dns_zone}
*/
export declare class DataAzurermPrivateDnsZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone azurerm_private_dns_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsZoneConfig);
    get id(): string;
    get maxNumberOfRecordSets(): number;
    get maxNumberOfVirtualNetworkLinks(): number;
    get maxNumberOfVirtualNetworkLinksWithRegistration(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsZoneTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPrivateDnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
