import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateEndpointConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#name DataAzurermPrivateEndpointConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#resource_group_name DataAzurermPrivateEndpointConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#timeouts DataAzurermPrivateEndpointConnection#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateEndpointConnectionTimeouts;
}
export declare class DataAzurermPrivateEndpointConnectionNetworkInterface extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
}
export declare class DataAzurermPrivateEndpointConnectionPrivateServiceConnection extends cdktf.ComplexComputedList {
    get name(): string;
    get privateIpAddress(): string;
    get requestResponse(): string;
    get status(): string;
}
export interface DataAzurermPrivateEndpointConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#read DataAzurermPrivateEndpointConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateEndpointConnectionTimeoutsToTerraform(struct?: DataAzurermPrivateEndpointConnectionTimeoutsOutputReference | DataAzurermPrivateEndpointConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateEndpointConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPrivateEndpointConnectionTimeouts | undefined;
    set internalValue(value: DataAzurermPrivateEndpointConnectionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection azurerm_private_endpoint_connection}
*/
export declare class DataAzurermPrivateEndpointConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection azurerm_private_endpoint_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateEndpointConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateEndpointConnectionConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    networkInterface(index: string): DataAzurermPrivateEndpointConnectionNetworkInterface;
    privateServiceConnection(index: string): DataAzurermPrivateEndpointConnectionPrivateServiceConnection;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPrivateEndpointConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateEndpointConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPrivateEndpointConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
