import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#name DataAzurermRedisCache#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#resource_group_name DataAzurermRedisCache#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#timeouts DataAzurermRedisCache#timeouts}
    */
    readonly timeouts?: DataAzurermRedisCacheTimeouts;
}
export declare class DataAzurermRedisCachePatchSchedule extends cdktf.ComplexComputedList {
    get dayOfWeek(): string;
    get maintenanceWindow(): string;
    get startHourUtc(): number;
}
export declare class DataAzurermRedisCacheRedisConfiguration extends cdktf.ComplexComputedList {
    get aofBackupEnabled(): cdktf.IResolvable;
    get aofStorageConnectionString0(): string;
    get aofStorageConnectionString1(): string;
    get enableAuthentication(): cdktf.IResolvable;
    get maxclients(): number;
    get maxfragmentationmemoryReserved(): number;
    get maxmemoryDelta(): number;
    get maxmemoryPolicy(): string;
    get maxmemoryReserved(): number;
    get notifyKeyspaceEvents(): string;
    get rdbBackupEnabled(): cdktf.IResolvable;
    get rdbBackupFrequency(): number;
    get rdbBackupMaxSnapshotCount(): number;
    get rdbStorageConnectionString(): string;
}
export interface DataAzurermRedisCacheTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#read DataAzurermRedisCache#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRedisCacheTimeoutsToTerraform(struct?: DataAzurermRedisCacheTimeoutsOutputReference | DataAzurermRedisCacheTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermRedisCacheTimeouts | undefined;
    set internalValue(value: DataAzurermRedisCacheTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache azurerm_redis_cache}
*/
export declare class DataAzurermRedisCache extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache azurerm_redis_cache} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRedisCacheConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRedisCacheConfig);
    get capacity(): number;
    get enableNonSslPort(): cdktf.IResolvable;
    get family(): string;
    get hostname(): string;
    get id(): string;
    get location(): string;
    get minimumTlsVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    patchSchedule(index: string): DataAzurermRedisCachePatchSchedule;
    get port(): number;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    get privateStaticIpAddress(): string;
    redisConfiguration(index: string): DataAzurermRedisCacheRedisConfiguration;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get shardCount(): number;
    get skuName(): string;
    get sslPort(): number;
    get subnetId(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermRedisCacheTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRedisCacheTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermRedisCacheTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
