import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_table#name DataAzurermRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_table#resource_group_name DataAzurermRouteTable#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_table#timeouts DataAzurermRouteTable#timeouts}
    */
    readonly timeouts?: DataAzurermRouteTableTimeouts;
}
export declare class DataAzurermRouteTableRoute extends cdktf.ComplexComputedList {
    get addressPrefix(): string;
    get name(): string;
    get nextHopInIpAddress(): string;
    get nextHopType(): string;
}
export interface DataAzurermRouteTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_table#read DataAzurermRouteTable#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRouteTableTimeoutsToTerraform(struct?: DataAzurermRouteTableTimeoutsOutputReference | DataAzurermRouteTableTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRouteTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermRouteTableTimeouts | undefined;
    set internalValue(value: DataAzurermRouteTableTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/route_table azurerm_route_table}
*/
export declare class DataAzurermRouteTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/route_table azurerm_route_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRouteTableConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRouteTableConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    route(index: string): DataAzurermRouteTableRoute;
    get subnets(): string[];
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermRouteTableTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRouteTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermRouteTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
