import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSearchServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#name DataAzurermSearchService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#resource_group_name DataAzurermSearchService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#timeouts DataAzurermSearchService#timeouts}
    */
    readonly timeouts?: DataAzurermSearchServiceTimeouts;
}
export declare class DataAzurermSearchServiceIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermSearchServiceQueryKeys extends cdktf.ComplexComputedList {
    get key(): string;
    get name(): string;
}
export interface DataAzurermSearchServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#read DataAzurermSearchService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSearchServiceTimeoutsToTerraform(struct?: DataAzurermSearchServiceTimeoutsOutputReference | DataAzurermSearchServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSearchServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSearchServiceTimeouts | undefined;
    set internalValue(value: DataAzurermSearchServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/search_service azurerm_search_service}
*/
export declare class DataAzurermSearchService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/search_service azurerm_search_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSearchServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSearchServiceConfig);
    get id(): string;
    identity(index: string): DataAzurermSearchServiceIdentity;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get partitionCount(): number;
    get primaryKey(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    queryKeys(index: string): DataAzurermSearchServiceQueryKeys;
    get replicaCount(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    private _timeouts;
    get timeouts(): DataAzurermSearchServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSearchServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSearchServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
