import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#name DataAzurermServicebusNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#resource_group_name DataAzurermServicebusNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#timeouts DataAzurermServicebusNamespace#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusNamespaceTimeouts;
}
export interface DataAzurermServicebusNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#read DataAzurermServicebusNamespace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusNamespaceTimeoutsToTerraform(struct?: DataAzurermServicebusNamespaceTimeoutsOutputReference | DataAzurermServicebusNamespaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermServicebusNamespaceTimeouts | undefined;
    set internalValue(value: DataAzurermServicebusNamespaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace azurerm_servicebus_namespace}
*/
export declare class DataAzurermServicebusNamespace extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace azurerm_servicebus_namespace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusNamespaceConfig);
    get capacity(): number;
    get defaultPrimaryConnectionString(): string;
    get defaultPrimaryKey(): string;
    get defaultSecondaryConnectionString(): string;
    get defaultSecondaryKey(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermServicebusNamespaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermServicebusNamespaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
