import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusQueueAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#name DataAzurermServicebusQueueAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#namespace_name DataAzurermServicebusQueueAuthorizationRule#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#queue_id DataAzurermServicebusQueueAuthorizationRule#queue_id}
    */
    readonly queueId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#queue_name DataAzurermServicebusQueueAuthorizationRule#queue_name}
    */
    readonly queueName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#resource_group_name DataAzurermServicebusQueueAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#timeouts DataAzurermServicebusQueueAuthorizationRule#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusQueueAuthorizationRuleTimeouts;
}
export interface DataAzurermServicebusQueueAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule#read DataAzurermServicebusQueueAuthorizationRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusQueueAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference | DataAzurermServicebusQueueAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined;
    set internalValue(value: DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule azurerm_servicebus_queue_authorization_rule}
*/
export declare class DataAzurermServicebusQueueAuthorizationRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule azurerm_servicebus_queue_authorization_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusQueueAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusQueueAuthorizationRuleConfig);
    get id(): string;
    get listen(): cdktf.IResolvable;
    get manage(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _queueId?;
    get queueId(): string;
    set queueId(value: string);
    resetQueueId(): void;
    get queueIdInput(): string | undefined;
    private _queueName?;
    get queueName(): string;
    set queueName(value: string);
    resetQueueName(): void;
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    get send(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusQueueAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
