import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusTopicAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#name DataAzurermServicebusTopicAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#namespace_name DataAzurermServicebusTopicAuthorizationRule#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#queue_name DataAzurermServicebusTopicAuthorizationRule#queue_name}
    */
    readonly queueName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#resource_group_name DataAzurermServicebusTopicAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#topic_id DataAzurermServicebusTopicAuthorizationRule#topic_id}
    */
    readonly topicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#topic_name DataAzurermServicebusTopicAuthorizationRule#topic_name}
    */
    readonly topicName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#timeouts DataAzurermServicebusTopicAuthorizationRule#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusTopicAuthorizationRuleTimeouts;
}
export interface DataAzurermServicebusTopicAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule#read DataAzurermServicebusTopicAuthorizationRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusTopicAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermServicebusTopicAuthorizationRuleTimeoutsOutputReference | DataAzurermServicebusTopicAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusTopicAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermServicebusTopicAuthorizationRuleTimeouts | undefined;
    set internalValue(value: DataAzurermServicebusTopicAuthorizationRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule}
*/
export declare class DataAzurermServicebusTopicAuthorizationRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusTopicAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusTopicAuthorizationRuleConfig);
    get id(): string;
    get listen(): cdktf.IResolvable;
    get manage(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _queueName?;
    get queueName(): string;
    set queueName(value: string);
    resetQueueName(): void;
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    get send(): cdktf.IResolvable;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermServicebusTopicAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusTopicAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermServicebusTopicAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
