import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image#gallery_name DataAzurermSharedImage#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image#name DataAzurermSharedImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image#resource_group_name DataAzurermSharedImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image#timeouts DataAzurermSharedImage#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageTimeouts;
}
export declare class DataAzurermSharedImageIdentifier extends cdktf.ComplexComputedList {
    get offer(): string;
    get publisher(): string;
    get sku(): string;
}
export interface DataAzurermSharedImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image#read DataAzurermSharedImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageTimeoutsToTerraform(struct?: DataAzurermSharedImageTimeoutsOutputReference | DataAzurermSharedImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSharedImageTimeouts | undefined;
    set internalValue(value: DataAzurermSharedImageTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image azurerm_shared_image}
*/
export declare class DataAzurermSharedImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image azurerm_shared_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageConfig);
    get description(): string;
    get eula(): string;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    get hyperVGeneration(): string;
    get id(): string;
    identifier(index: string): DataAzurermSharedImageIdentifier;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    get privacyStatementUri(): string;
    get releaseNoteUri(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get specialized(): cdktf.IResolvable;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSharedImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
