import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#name DataAzurermSnapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#resource_group_name DataAzurermSnapshot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#timeouts DataAzurermSnapshot#timeouts}
    */
    readonly timeouts?: DataAzurermSnapshotTimeouts;
}
export declare class DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey extends cdktf.ComplexComputedList {
    get secretUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey extends cdktf.ComplexComputedList {
    get keyUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermSnapshotEncryptionSettings extends cdktf.ComplexComputedList {
    get diskEncryptionKey(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get keyEncryptionKey(): cdktf.IResolvable;
}
export interface DataAzurermSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#read DataAzurermSnapshot#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSnapshotTimeoutsToTerraform(struct?: DataAzurermSnapshotTimeoutsOutputReference | DataAzurermSnapshotTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSnapshotTimeouts | undefined;
    set internalValue(value: DataAzurermSnapshotTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot azurerm_snapshot}
*/
export declare class DataAzurermSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot azurerm_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSnapshotConfig);
    get creationOption(): string;
    get diskSizeGb(): number;
    encryptionSettings(index: string): DataAzurermSnapshotEncryptionSettings;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get timeCreated(): string;
    private _timeouts;
    get timeouts(): DataAzurermSnapshotTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
