import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpringCloudAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#name DataAzurermSpringCloudApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#resource_group_name DataAzurermSpringCloudApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#service_name DataAzurermSpringCloudApp#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#timeouts DataAzurermSpringCloudApp#timeouts}
    */
    readonly timeouts?: DataAzurermSpringCloudAppTimeouts;
}
export declare class DataAzurermSpringCloudAppIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermSpringCloudAppPersistentDisk extends cdktf.ComplexComputedList {
    get mountPath(): string;
    get sizeInGb(): number;
}
export interface DataAzurermSpringCloudAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#read DataAzurermSpringCloudApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudAppTimeoutsToTerraform(struct?: DataAzurermSpringCloudAppTimeoutsOutputReference | DataAzurermSpringCloudAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpringCloudAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSpringCloudAppTimeouts | undefined;
    set internalValue(value: DataAzurermSpringCloudAppTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app}
*/
export declare class DataAzurermSpringCloudApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpringCloudAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudAppConfig);
    get fqdn(): string;
    get httpsOnly(): cdktf.IResolvable;
    get id(): string;
    identity(index: string): DataAzurermSpringCloudAppIdentity;
    get isPublic(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    persistentDisk(index: string): DataAzurermSpringCloudAppPersistentDisk;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    get tlsEnabled(): cdktf.IResolvable;
    get url(): string;
    private _timeouts;
    get timeouts(): DataAzurermSpringCloudAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpringCloudAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSpringCloudAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
