import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageSyncGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group#name DataAzurermStorageSyncGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group#storage_sync_id DataAzurermStorageSyncGroup#storage_sync_id}
    */
    readonly storageSyncId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group#timeouts DataAzurermStorageSyncGroup#timeouts}
    */
    readonly timeouts?: DataAzurermStorageSyncGroupTimeouts;
}
export interface DataAzurermStorageSyncGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group#read DataAzurermStorageSyncGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageSyncGroupTimeoutsToTerraform(struct?: DataAzurermStorageSyncGroupTimeoutsOutputReference | DataAzurermStorageSyncGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageSyncGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStorageSyncGroupTimeouts | undefined;
    set internalValue(value: DataAzurermStorageSyncGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group azurerm_storage_sync_group}
*/
export declare class DataAzurermStorageSyncGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync_group azurerm_storage_sync_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageSyncGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageSyncGroupConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageSyncId?;
    get storageSyncId(): string;
    set storageSyncId(value: string);
    get storageSyncIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageSyncGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageSyncGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageSyncGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
