import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageTableEntityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#partition_key DataAzurermStorageTableEntity#partition_key}
    */
    readonly partitionKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#row_key DataAzurermStorageTableEntity#row_key}
    */
    readonly rowKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#storage_account_name DataAzurermStorageTableEntity#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#table_name DataAzurermStorageTableEntity#table_name}
    */
    readonly tableName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#timeouts DataAzurermStorageTableEntity#timeouts}
    */
    readonly timeouts?: DataAzurermStorageTableEntityTimeouts;
}
export interface DataAzurermStorageTableEntityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity#read DataAzurermStorageTableEntity#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageTableEntityTimeoutsToTerraform(struct?: DataAzurermStorageTableEntityTimeoutsOutputReference | DataAzurermStorageTableEntityTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageTableEntityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStorageTableEntityTimeouts | undefined;
    set internalValue(value: DataAzurermStorageTableEntityTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity azurerm_storage_table_entity}
*/
export declare class DataAzurermStorageTableEntity extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity azurerm_storage_table_entity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageTableEntityConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageTableEntityConfig);
    entity(key: string): string | cdktf.IResolvable;
    get id(): string;
    private _partitionKey?;
    get partitionKey(): string;
    set partitionKey(value: string);
    get partitionKeyInput(): string | undefined;
    private _rowKey?;
    get rowKey(): string;
    set rowKey(value: string);
    get rowKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageTableEntityTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageTableEntityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageTableEntityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
