import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStreamAnalyticsJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job#name DataAzurermStreamAnalyticsJob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job#resource_group_name DataAzurermStreamAnalyticsJob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job#timeouts DataAzurermStreamAnalyticsJob#timeouts}
    */
    readonly timeouts?: DataAzurermStreamAnalyticsJobTimeouts;
}
export declare class DataAzurermStreamAnalyticsJobIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermStreamAnalyticsJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job#read DataAzurermStreamAnalyticsJob#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStreamAnalyticsJobTimeoutsToTerraform(struct?: DataAzurermStreamAnalyticsJobTimeoutsOutputReference | DataAzurermStreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStreamAnalyticsJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStreamAnalyticsJobTimeouts | undefined;
    set internalValue(value: DataAzurermStreamAnalyticsJobTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job azurerm_stream_analytics_job}
*/
export declare class DataAzurermStreamAnalyticsJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job azurerm_stream_analytics_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStreamAnalyticsJobConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStreamAnalyticsJobConfig);
    get compatibilityLevel(): string;
    get dataLocale(): string;
    get eventsLateArrivalMaxDelayInSeconds(): number;
    get eventsOutOfOrderMaxDelayInSeconds(): number;
    get eventsOutOfOrderPolicy(): string;
    get id(): string;
    identity(index: string): DataAzurermStreamAnalyticsJobIdentity;
    get jobId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputErrorPolicy(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get streamingUnits(): number;
    get transformationQuery(): string;
    private _timeouts;
    get timeouts(): DataAzurermStreamAnalyticsJobTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStreamAnalyticsJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStreamAnalyticsJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
