import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubscriptionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#display_name_contains DataAzurermSubscriptions#display_name_contains}
    */
    readonly displayNameContains?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#display_name_prefix DataAzurermSubscriptions#display_name_prefix}
    */
    readonly displayNamePrefix?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#timeouts DataAzurermSubscriptions#timeouts}
    */
    readonly timeouts?: DataAzurermSubscriptionsTimeouts;
}
export declare class DataAzurermSubscriptionsSubscriptions extends cdktf.ComplexComputedList {
    get displayName(): string;
    get id(): string;
    get locationPlacementId(): string;
    get quotaId(): string;
    get spendingLimit(): string;
    get state(): string;
    get subscriptionId(): string;
    get tags(): {
        [key: string]: string;
    };
    get tenantId(): string;
}
export interface DataAzurermSubscriptionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#read DataAzurermSubscriptions#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionsTimeoutsToTerraform(struct?: DataAzurermSubscriptionsTimeoutsOutputReference | DataAzurermSubscriptionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubscriptionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSubscriptionsTimeouts | undefined;
    set internalValue(value: DataAzurermSubscriptionsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions azurerm_subscriptions}
*/
export declare class DataAzurermSubscriptions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions azurerm_subscriptions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubscriptionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionsConfig);
    private _displayNameContains?;
    get displayNameContains(): string;
    set displayNameContains(value: string);
    resetDisplayNameContains(): void;
    get displayNameContainsInput(): string | undefined;
    private _displayNamePrefix?;
    get displayNamePrefix(): string;
    set displayNamePrefix(value: string);
    resetDisplayNamePrefix(): void;
    get displayNamePrefixInput(): string | undefined;
    get id(): string;
    subscriptions(index: string): DataAzurermSubscriptionsSubscriptions;
    private _timeouts;
    get timeouts(): DataAzurermSubscriptionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubscriptionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSubscriptionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
