import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSynapseWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace#name DataAzurermSynapseWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace#resource_group_name DataAzurermSynapseWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace#timeouts DataAzurermSynapseWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermSynapseWorkspaceTimeouts;
}
export declare class DataAzurermSynapseWorkspaceIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermSynapseWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace#read DataAzurermSynapseWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSynapseWorkspaceTimeoutsToTerraform(struct?: DataAzurermSynapseWorkspaceTimeoutsOutputReference | DataAzurermSynapseWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSynapseWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSynapseWorkspaceTimeouts | undefined;
    set internalValue(value: DataAzurermSynapseWorkspaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace azurerm_synapse_workspace}
*/
export declare class DataAzurermSynapseWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/synapse_workspace azurerm_synapse_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSynapseWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSynapseWorkspaceConfig);
    connectivityEndpoints(key: string): string | cdktf.IResolvable;
    get id(): string;
    identity(index: string): DataAzurermSynapseWorkspaceIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSynapseWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSynapseWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSynapseWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
