import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermTrafficManagerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#name DataAzurermTrafficManagerProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#resource_group_name DataAzurermTrafficManagerProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#tags DataAzurermTrafficManagerProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#traffic_view_enabled DataAzurermTrafficManagerProfile#traffic_view_enabled}
    */
    readonly trafficViewEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#timeouts DataAzurermTrafficManagerProfile#timeouts}
    */
    readonly timeouts?: DataAzurermTrafficManagerProfileTimeouts;
}
export declare class DataAzurermTrafficManagerProfileDnsConfig extends cdktf.ComplexComputedList {
    get relativeName(): string;
    get ttl(): number;
}
export declare class DataAzurermTrafficManagerProfileMonitorConfigCustomHeader extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataAzurermTrafficManagerProfileMonitorConfig extends cdktf.ComplexComputedList {
    get customHeader(): cdktf.IResolvable;
    get expectedStatusCodeRanges(): string[];
    get intervalInSeconds(): number;
    get path(): string;
    get port(): number;
    get protocol(): string;
    get timeoutInSeconds(): number;
    get toleratedNumberOfFailures(): number;
}
export interface DataAzurermTrafficManagerProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#read DataAzurermTrafficManagerProfile#read}
    */
    readonly read?: string;
}
export declare function dataAzurermTrafficManagerProfileTimeoutsToTerraform(struct?: DataAzurermTrafficManagerProfileTimeoutsOutputReference | DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermTrafficManagerProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermTrafficManagerProfileTimeouts | undefined;
    set internalValue(value: DataAzurermTrafficManagerProfileTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile azurerm_traffic_manager_profile}
*/
export declare class DataAzurermTrafficManagerProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile azurerm_traffic_manager_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermTrafficManagerProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermTrafficManagerProfileConfig);
    dnsConfig(index: string): DataAzurermTrafficManagerProfileDnsConfig;
    get fqdn(): string;
    get id(): string;
    monitorConfig(index: string): DataAzurermTrafficManagerProfileMonitorConfig;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get profileStatus(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get trafficRoutingMethod(): string;
    private _trafficViewEnabled?;
    get trafficViewEnabled(): boolean | cdktf.IResolvable;
    set trafficViewEnabled(value: boolean | cdktf.IResolvable);
    resetTrafficViewEnabled(): void;
    get trafficViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): DataAzurermTrafficManagerProfileTimeoutsOutputReference;
    putTimeouts(value: DataAzurermTrafficManagerProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermTrafficManagerProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
