import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine#name DataAzurermVirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine#resource_group_name DataAzurermVirtualMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine#timeouts DataAzurermVirtualMachine#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualMachineTimeouts;
}
export declare class DataAzurermVirtualMachineIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermVirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine#read DataAzurermVirtualMachine#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualMachineTimeoutsToTerraform(struct?: DataAzurermVirtualMachineTimeoutsOutputReference | DataAzurermVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVirtualMachineTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualMachineTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine azurerm_virtual_machine}
*/
export declare class DataAzurermVirtualMachine extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine azurerm_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualMachineConfig);
    get id(): string;
    identity(index: string): DataAzurermVirtualMachineIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    get publicIpAddress(): string;
    get publicIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualMachineTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
