import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection#name DataAzurermVirtualNetworkGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection#resource_group_name DataAzurermVirtualNetworkGatewayConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection#timeouts DataAzurermVirtualNetworkGatewayConnection#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayConnectionTimeouts;
}
export declare class DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy extends cdktf.ComplexComputedList {
    get dhGroup(): string;
    get ikeEncryption(): string;
    get ikeIntegrity(): string;
    get ipsecEncryption(): string;
    get ipsecIntegrity(): string;
    get pfsGroup(): string;
    get saDatasize(): number;
    get saLifetime(): number;
}
export declare class DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy extends cdktf.ComplexComputedList {
    get localAddressCidrs(): string[];
    get remoteAddressCidrs(): string[];
}
export interface DataAzurermVirtualNetworkGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection#read DataAzurermVirtualNetworkGatewayConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference | DataAzurermVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection}
*/
export declare class DataAzurermVirtualNetworkGatewayConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConnectionConfig);
    get authorizationKey(): string;
    get connectionProtocol(): string;
    get dpdTimeoutSeconds(): number;
    get egressBytesTransferred(): number;
    get enableBgp(): cdktf.IResolvable;
    get expressRouteCircuitId(): string;
    get expressRouteGatewayBypass(): cdktf.IResolvable;
    get id(): string;
    get ingressBytesTransferred(): number;
    ipsecPolicy(index: string): DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy;
    get localAzureIpAddressEnabled(): cdktf.IResolvable;
    get localNetworkGatewayId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get peerVirtualNetworkGatewayId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceGuid(): string;
    get routingWeight(): number;
    get sharedKey(): string;
    tags(key: string): string | cdktf.IResolvable;
    trafficSelectorPolicy(index: string): DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy;
    get type(): string;
    get usePolicyBasedTrafficSelectors(): cdktf.IResolvable;
    get virtualNetworkGatewayId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
