import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVmwarePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud#name DataAzurermVmwarePrivateCloud#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud#resource_group_name DataAzurermVmwarePrivateCloud#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud#timeouts DataAzurermVmwarePrivateCloud#timeouts}
    */
    readonly timeouts?: DataAzurermVmwarePrivateCloudTimeouts;
}
export declare class DataAzurermVmwarePrivateCloudCircuit extends cdktf.ComplexComputedList {
    get expressRouteId(): string;
    get expressRoutePrivatePeeringId(): string;
    get primarySubnetCidr(): string;
    get secondarySubnetCidr(): string;
}
export declare class DataAzurermVmwarePrivateCloudManagementCluster extends cdktf.ComplexComputedList {
    get hosts(): string[];
    get id(): number;
    get size(): number;
}
export interface DataAzurermVmwarePrivateCloudTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud#read DataAzurermVmwarePrivateCloud#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVmwarePrivateCloudTimeoutsToTerraform(struct?: DataAzurermVmwarePrivateCloudTimeoutsOutputReference | DataAzurermVmwarePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVmwarePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVmwarePrivateCloudTimeouts | undefined;
    set internalValue(value: DataAzurermVmwarePrivateCloudTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud azurerm_vmware_private_cloud}
*/
export declare class DataAzurermVmwarePrivateCloud extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/vmware_private_cloud azurerm_vmware_private_cloud} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVmwarePrivateCloudConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVmwarePrivateCloudConfig);
    circuit(index: string): DataAzurermVmwarePrivateCloudCircuit;
    get hcxCloudManagerEndpoint(): string;
    get id(): string;
    get internetConnectionEnabled(): cdktf.IResolvable;
    get location(): string;
    managementCluster(index: string): DataAzurermVmwarePrivateCloudManagementCluster;
    get managementSubnetCidr(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSubnetCidr(): string;
    get nsxtCertificateThumbprint(): string;
    get nsxtManagerEndpoint(): string;
    get provisioningSubnetCidr(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    tags(key: string): string | cdktf.IResolvable;
    get vcenterCertificateThumbprint(): string;
    get vcsaEndpoint(): string;
    get vmotionSubnetCidr(): string;
    private _timeouts;
    get timeouts(): DataAzurermVmwarePrivateCloudTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVmwarePrivateCloudTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVmwarePrivateCloudTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
