import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDatasetBinaryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#additional_properties DataFactoryDatasetBinary#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#annotations DataFactoryDatasetBinary#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#data_factory_id DataFactoryDatasetBinary#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#data_factory_name DataFactoryDatasetBinary#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#description DataFactoryDatasetBinary#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#folder DataFactoryDatasetBinary#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#linked_service_name DataFactoryDatasetBinary#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#name DataFactoryDatasetBinary#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#parameters DataFactoryDatasetBinary#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#resource_group_name DataFactoryDatasetBinary#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * azure_blob_storage_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#azure_blob_storage_location DataFactoryDatasetBinary#azure_blob_storage_location}
    */
    readonly azureBlobStorageLocation?: DataFactoryDatasetBinaryAzureBlobStorageLocation;
    /**
    * compression block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#compression DataFactoryDatasetBinary#compression}
    */
    readonly compression?: DataFactoryDatasetBinaryCompression;
    /**
    * http_server_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#http_server_location DataFactoryDatasetBinary#http_server_location}
    */
    readonly httpServerLocation?: DataFactoryDatasetBinaryHttpServerLocation;
    /**
    * sftp_server_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#sftp_server_location DataFactoryDatasetBinary#sftp_server_location}
    */
    readonly sftpServerLocation?: DataFactoryDatasetBinarySftpServerLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#timeouts DataFactoryDatasetBinary#timeouts}
    */
    readonly timeouts?: DataFactoryDatasetBinaryTimeouts;
}
export interface DataFactoryDatasetBinaryAzureBlobStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#container DataFactoryDatasetBinary#container}
    */
    readonly container: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#filename DataFactoryDatasetBinary#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#path DataFactoryDatasetBinary#path}
    */
    readonly path?: string;
}
export declare function dataFactoryDatasetBinaryAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference | DataFactoryDatasetBinaryAzureBlobStorageLocation): any;
export declare class DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined;
    set internalValue(value: DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface DataFactoryDatasetBinaryCompression {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#level DataFactoryDatasetBinary#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#type DataFactoryDatasetBinary#type}
    */
    readonly type: string;
}
export declare function dataFactoryDatasetBinaryCompressionToTerraform(struct?: DataFactoryDatasetBinaryCompressionOutputReference | DataFactoryDatasetBinaryCompression): any;
export declare class DataFactoryDatasetBinaryCompressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetBinaryCompression | undefined;
    set internalValue(value: DataFactoryDatasetBinaryCompression | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataFactoryDatasetBinaryHttpServerLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#filename DataFactoryDatasetBinary#filename}
    */
    readonly filename: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#path DataFactoryDatasetBinary#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#relative_url DataFactoryDatasetBinary#relative_url}
    */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetBinaryHttpServerLocationToTerraform(struct?: DataFactoryDatasetBinaryHttpServerLocationOutputReference | DataFactoryDatasetBinaryHttpServerLocation): any;
export declare class DataFactoryDatasetBinaryHttpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetBinaryHttpServerLocation | undefined;
    set internalValue(value: DataFactoryDatasetBinaryHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _relativeUrl?;
    get relativeUrl(): string;
    set relativeUrl(value: string);
    get relativeUrlInput(): string | undefined;
}
export interface DataFactoryDatasetBinarySftpServerLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#filename DataFactoryDatasetBinary#filename}
    */
    readonly filename: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#path DataFactoryDatasetBinary#path}
    */
    readonly path: string;
}
export declare function dataFactoryDatasetBinarySftpServerLocationToTerraform(struct?: DataFactoryDatasetBinarySftpServerLocationOutputReference | DataFactoryDatasetBinarySftpServerLocation): any;
export declare class DataFactoryDatasetBinarySftpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetBinarySftpServerLocation | undefined;
    set internalValue(value: DataFactoryDatasetBinarySftpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataFactoryDatasetBinaryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#create DataFactoryDatasetBinary#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#delete DataFactoryDatasetBinary#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#read DataFactoryDatasetBinary#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary#update DataFactoryDatasetBinary#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDatasetBinaryTimeoutsToTerraform(struct?: DataFactoryDatasetBinaryTimeoutsOutputReference | DataFactoryDatasetBinaryTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDatasetBinaryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetBinaryTimeouts | undefined;
    set internalValue(value: DataFactoryDatasetBinaryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary azurerm_data_factory_dataset_binary}
*/
export declare class DataFactoryDatasetBinary extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary azurerm_data_factory_dataset_binary} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDatasetBinaryConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetBinaryConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get id(): string;
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _azureBlobStorageLocation;
    get azureBlobStorageLocation(): DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference;
    putAzureBlobStorageLocation(value: DataFactoryDatasetBinaryAzureBlobStorageLocation): void;
    resetAzureBlobStorageLocation(): void;
    get azureBlobStorageLocationInput(): DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined;
    private _compression;
    get compression(): DataFactoryDatasetBinaryCompressionOutputReference;
    putCompression(value: DataFactoryDatasetBinaryCompression): void;
    resetCompression(): void;
    get compressionInput(): DataFactoryDatasetBinaryCompression | undefined;
    private _httpServerLocation;
    get httpServerLocation(): DataFactoryDatasetBinaryHttpServerLocationOutputReference;
    putHttpServerLocation(value: DataFactoryDatasetBinaryHttpServerLocation): void;
    resetHttpServerLocation(): void;
    get httpServerLocationInput(): DataFactoryDatasetBinaryHttpServerLocation | undefined;
    private _sftpServerLocation;
    get sftpServerLocation(): DataFactoryDatasetBinarySftpServerLocationOutputReference;
    putSftpServerLocation(value: DataFactoryDatasetBinarySftpServerLocation): void;
    resetSftpServerLocation(): void;
    get sftpServerLocationInput(): DataFactoryDatasetBinarySftpServerLocation | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDatasetBinaryTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDatasetBinaryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryDatasetBinaryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
