import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeStoreFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#account_name DataLakeStoreFile#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#local_file_path DataLakeStoreFile#local_file_path}
    */
    readonly localFilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#remote_file_path DataLakeStoreFile#remote_file_path}
    */
    readonly remoteFilePath: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#timeouts DataLakeStoreFile#timeouts}
    */
    readonly timeouts?: DataLakeStoreFileTimeouts;
}
export interface DataLakeStoreFileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#create DataLakeStoreFile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#delete DataLakeStoreFile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#read DataLakeStoreFile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file#update DataLakeStoreFile#update}
    */
    readonly update?: string;
}
export declare function dataLakeStoreFileTimeoutsToTerraform(struct?: DataLakeStoreFileTimeoutsOutputReference | DataLakeStoreFileTimeouts | cdktf.IResolvable): any;
export declare class DataLakeStoreFileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataLakeStoreFileTimeouts | undefined;
    set internalValue(value: DataLakeStoreFileTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file azurerm_data_lake_store_file}
*/
export declare class DataLakeStoreFile extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_file azurerm_data_lake_store_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeStoreFileConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeStoreFileConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get id(): string;
    private _localFilePath?;
    get localFilePath(): string;
    set localFilePath(value: string);
    get localFilePathInput(): string | undefined;
    private _remoteFilePath?;
    get remoteFilePath(): string;
    set remoteFilePath(value: string);
    get remoteFilePathInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataLakeStoreFileTimeoutsOutputReference;
    putTimeouts(value: DataLakeStoreFileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLakeStoreFileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
