import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeStoreVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#account_name DataLakeStoreVirtualNetworkRule#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#name DataLakeStoreVirtualNetworkRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#resource_group_name DataLakeStoreVirtualNetworkRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#subnet_id DataLakeStoreVirtualNetworkRule#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#timeouts DataLakeStoreVirtualNetworkRule#timeouts}
    */
    readonly timeouts?: DataLakeStoreVirtualNetworkRuleTimeouts;
}
export interface DataLakeStoreVirtualNetworkRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#create DataLakeStoreVirtualNetworkRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#delete DataLakeStoreVirtualNetworkRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#read DataLakeStoreVirtualNetworkRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule#update DataLakeStoreVirtualNetworkRule#update}
    */
    readonly update?: string;
}
export declare function dataLakeStoreVirtualNetworkRuleTimeoutsToTerraform(struct?: DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference | DataLakeStoreVirtualNetworkRuleTimeouts | cdktf.IResolvable): any;
export declare class DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataLakeStoreVirtualNetworkRuleTimeouts | undefined;
    set internalValue(value: DataLakeStoreVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule azurerm_data_lake_store_virtual_network_rule}
*/
export declare class DataLakeStoreVirtualNetworkRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule azurerm_data_lake_store_virtual_network_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeStoreVirtualNetworkRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeStoreVirtualNetworkRuleConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference;
    putTimeouts(value: DataLakeStoreVirtualNetworkRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLakeStoreVirtualNetworkRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
