import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevspaceControllerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#location DevspaceController#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#name DevspaceController#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#resource_group_name DevspaceController#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#sku_name DevspaceController#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#tags DevspaceController#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#target_container_host_credentials_base64 DevspaceController#target_container_host_credentials_base64}
    */
    readonly targetContainerHostCredentialsBase64: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#target_container_host_resource_id DevspaceController#target_container_host_resource_id}
    */
    readonly targetContainerHostResourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#timeouts DevspaceController#timeouts}
    */
    readonly timeouts?: DevspaceControllerTimeouts;
}
export interface DevspaceControllerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#create DevspaceController#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#delete DevspaceController#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#read DevspaceController#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller#update DevspaceController#update}
    */
    readonly update?: string;
}
export declare function devspaceControllerTimeoutsToTerraform(struct?: DevspaceControllerTimeoutsOutputReference | DevspaceControllerTimeouts | cdktf.IResolvable): any;
export declare class DevspaceControllerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevspaceControllerTimeouts | undefined;
    set internalValue(value: DevspaceControllerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller azurerm_devspace_controller}
*/
export declare class DevspaceController extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/devspace_controller azurerm_devspace_controller} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevspaceControllerConfig
    */
    constructor(scope: Construct, id: string, config: DevspaceControllerConfig);
    get dataPlaneFqdn(): string;
    get hostSuffix(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetContainerHostCredentialsBase64?;
    get targetContainerHostCredentialsBase64(): string;
    set targetContainerHostCredentialsBase64(value: string);
    get targetContainerHostCredentialsBase64Input(): string | undefined;
    private _targetContainerHostResourceId?;
    get targetContainerHostResourceId(): string;
    set targetContainerHostResourceId(value: string);
    get targetContainerHostResourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DevspaceControllerTimeoutsOutputReference;
    putTimeouts(value: DevspaceControllerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DevspaceControllerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
