import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DigitalTwinsEndpointEventhubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#dead_letter_storage_secret DigitalTwinsEndpointEventhub#dead_letter_storage_secret}
    */
    readonly deadLetterStorageSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#digital_twins_id DigitalTwinsEndpointEventhub#digital_twins_id}
    */
    readonly digitalTwinsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#eventhub_primary_connection_string DigitalTwinsEndpointEventhub#eventhub_primary_connection_string}
    */
    readonly eventhubPrimaryConnectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#eventhub_secondary_connection_string DigitalTwinsEndpointEventhub#eventhub_secondary_connection_string}
    */
    readonly eventhubSecondaryConnectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#name DigitalTwinsEndpointEventhub#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#timeouts DigitalTwinsEndpointEventhub#timeouts}
    */
    readonly timeouts?: DigitalTwinsEndpointEventhubTimeouts;
}
export interface DigitalTwinsEndpointEventhubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#create DigitalTwinsEndpointEventhub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#delete DigitalTwinsEndpointEventhub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#read DigitalTwinsEndpointEventhub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#update DigitalTwinsEndpointEventhub#update}
    */
    readonly update?: string;
}
export declare function digitalTwinsEndpointEventhubTimeoutsToTerraform(struct?: DigitalTwinsEndpointEventhubTimeoutsOutputReference | DigitalTwinsEndpointEventhubTimeouts | cdktf.IResolvable): any;
export declare class DigitalTwinsEndpointEventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DigitalTwinsEndpointEventhubTimeouts | undefined;
    set internalValue(value: DigitalTwinsEndpointEventhubTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub azurerm_digital_twins_endpoint_eventhub}
*/
export declare class DigitalTwinsEndpointEventhub extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub azurerm_digital_twins_endpoint_eventhub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DigitalTwinsEndpointEventhubConfig
    */
    constructor(scope: Construct, id: string, config: DigitalTwinsEndpointEventhubConfig);
    private _deadLetterStorageSecret?;
    get deadLetterStorageSecret(): string;
    set deadLetterStorageSecret(value: string);
    resetDeadLetterStorageSecret(): void;
    get deadLetterStorageSecretInput(): string | undefined;
    private _digitalTwinsId?;
    get digitalTwinsId(): string;
    set digitalTwinsId(value: string);
    get digitalTwinsIdInput(): string | undefined;
    private _eventhubPrimaryConnectionString?;
    get eventhubPrimaryConnectionString(): string;
    set eventhubPrimaryConnectionString(value: string);
    get eventhubPrimaryConnectionStringInput(): string | undefined;
    private _eventhubSecondaryConnectionString?;
    get eventhubSecondaryConnectionString(): string;
    set eventhubSecondaryConnectionString(value: string);
    get eventhubSecondaryConnectionStringInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DigitalTwinsEndpointEventhubTimeoutsOutputReference;
    putTimeouts(value: DigitalTwinsEndpointEventhubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DigitalTwinsEndpointEventhubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
