import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsSrvRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#name DnsSrvRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#resource_group_name DnsSrvRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#tags DnsSrvRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#ttl DnsSrvRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#zone_name DnsSrvRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * record block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#record DnsSrvRecord#record}
    */
    readonly record: DnsSrvRecordRecord[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#timeouts DnsSrvRecord#timeouts}
    */
    readonly timeouts?: DnsSrvRecordTimeouts;
}
export interface DnsSrvRecordRecord {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#port DnsSrvRecord#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#priority DnsSrvRecord#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#target DnsSrvRecord#target}
    */
    readonly target: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#weight DnsSrvRecord#weight}
    */
    readonly weight: number;
}
export declare function dnsSrvRecordRecordToTerraform(struct?: DnsSrvRecordRecord | cdktf.IResolvable): any;
export interface DnsSrvRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#create DnsSrvRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#delete DnsSrvRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#read DnsSrvRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record#update DnsSrvRecord#update}
    */
    readonly update?: string;
}
export declare function dnsSrvRecordTimeoutsToTerraform(struct?: DnsSrvRecordTimeoutsOutputReference | DnsSrvRecordTimeouts | cdktf.IResolvable): any;
export declare class DnsSrvRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DnsSrvRecordTimeouts | undefined;
    set internalValue(value: DnsSrvRecordTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record azurerm_dns_srv_record}
*/
export declare class DnsSrvRecord extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record azurerm_dns_srv_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsSrvRecordConfig
    */
    constructor(scope: Construct, id: string, config: DnsSrvRecordConfig);
    get fqdn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _record?;
    get record(): DnsSrvRecordRecord[] | cdktf.IResolvable;
    set record(value: DnsSrvRecordRecord[] | cdktf.IResolvable);
    get recordInput(): cdktf.IResolvable | DnsSrvRecordRecord[] | undefined;
    private _timeouts;
    get timeouts(): DnsSrvRecordTimeoutsOutputReference;
    putTimeouts(value: DnsSrvRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsSrvRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
