import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridDomainTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#domain_name EventgridDomainTopic#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#name EventgridDomainTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#resource_group_name EventgridDomainTopic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#timeouts EventgridDomainTopic#timeouts}
    */
    readonly timeouts?: EventgridDomainTopicTimeouts;
}
export interface EventgridDomainTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#create EventgridDomainTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#delete EventgridDomainTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic#read EventgridDomainTopic#read}
    */
    readonly read?: string;
}
export declare function eventgridDomainTopicTimeoutsToTerraform(struct?: EventgridDomainTopicTimeoutsOutputReference | EventgridDomainTopicTimeouts | cdktf.IResolvable): any;
export declare class EventgridDomainTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridDomainTopicTimeouts | undefined;
    set internalValue(value: EventgridDomainTopicTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic azurerm_eventgrid_domain_topic}
*/
export declare class EventgridDomainTopic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain_topic azurerm_eventgrid_domain_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridDomainTopicConfig
    */
    constructor(scope: Construct, id: string, config: EventgridDomainTopicConfig);
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): EventgridDomainTopicTimeoutsOutputReference;
    putTimeouts(value: EventgridDomainTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EventgridDomainTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
