import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridEventSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#advanced_filtering_on_arrays_enabled EventgridEventSubscription#advanced_filtering_on_arrays_enabled}
    */
    readonly advancedFilteringOnArraysEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#event_delivery_schema EventgridEventSubscription#event_delivery_schema}
    */
    readonly eventDeliverySchema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_endpoint_id EventgridEventSubscription#eventhub_endpoint_id}
    */
    readonly eventhubEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#expiration_time_utc EventgridEventSubscription#expiration_time_utc}
    */
    readonly expirationTimeUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_endpoint_id EventgridEventSubscription#hybrid_connection_endpoint_id}
    */
    readonly hybridConnectionEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#included_event_types EventgridEventSubscription#included_event_types}
    */
    readonly includedEventTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#labels EventgridEventSubscription#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#name EventgridEventSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#scope EventgridEventSubscription#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#service_bus_queue_endpoint_id EventgridEventSubscription#service_bus_queue_endpoint_id}
    */
    readonly serviceBusQueueEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#service_bus_topic_endpoint_id EventgridEventSubscription#service_bus_topic_endpoint_id}
    */
    readonly serviceBusTopicEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#topic_name EventgridEventSubscription#topic_name}
    */
    readonly topicName?: string;
    /**
    * advanced_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#advanced_filter EventgridEventSubscription#advanced_filter}
    */
    readonly advancedFilter?: EventgridEventSubscriptionAdvancedFilter;
    /**
    * azure_function_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#azure_function_endpoint EventgridEventSubscription#azure_function_endpoint}
    */
    readonly azureFunctionEndpoint?: EventgridEventSubscriptionAzureFunctionEndpoint;
    /**
    * dead_letter_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#dead_letter_identity EventgridEventSubscription#dead_letter_identity}
    */
    readonly deadLetterIdentity?: EventgridEventSubscriptionDeadLetterIdentity;
    /**
    * delivery_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delivery_identity EventgridEventSubscription#delivery_identity}
    */
    readonly deliveryIdentity?: EventgridEventSubscriptionDeliveryIdentity;
    /**
    * delivery_property block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delivery_property EventgridEventSubscription#delivery_property}
    */
    readonly deliveryProperty?: EventgridEventSubscriptionDeliveryProperty[] | cdktf.IResolvable;
    /**
    * eventhub_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_endpoint EventgridEventSubscription#eventhub_endpoint}
    */
    readonly eventhubEndpoint?: EventgridEventSubscriptionEventhubEndpoint;
    /**
    * hybrid_connection_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_endpoint EventgridEventSubscription#hybrid_connection_endpoint}
    */
    readonly hybridConnectionEndpoint?: EventgridEventSubscriptionHybridConnectionEndpoint;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#retry_policy EventgridEventSubscription#retry_policy}
    */
    readonly retryPolicy?: EventgridEventSubscriptionRetryPolicy;
    /**
    * storage_blob_dead_letter_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_blob_dead_letter_destination EventgridEventSubscription#storage_blob_dead_letter_destination}
    */
    readonly storageBlobDeadLetterDestination?: EventgridEventSubscriptionStorageBlobDeadLetterDestination;
    /**
    * storage_queue_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_queue_endpoint EventgridEventSubscription#storage_queue_endpoint}
    */
    readonly storageQueueEndpoint?: EventgridEventSubscriptionStorageQueueEndpoint;
    /**
    * subject_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_filter EventgridEventSubscription#subject_filter}
    */
    readonly subjectFilter?: EventgridEventSubscriptionSubjectFilter;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#timeouts EventgridEventSubscription#timeouts}
    */
    readonly timeouts?: EventgridEventSubscriptionTimeouts;
    /**
    * webhook_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#webhook_endpoint EventgridEventSubscription#webhook_endpoint}
    */
    readonly webhookEndpoint?: EventgridEventSubscriptionWebhookEndpoint;
}
export interface EventgridEventSubscriptionAdvancedFilterBoolEquals {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value: boolean | cdktf.IResolvable;
}
export declare function eventgridEventSubscriptionAdvancedFilterBoolEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterBoolEquals | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterIsNotNull {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
}
export declare function eventgridEventSubscriptionAdvancedFilterIsNotNullToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterIsNotNull | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
}
export declare function eventgridEventSubscriptionAdvancedFilterIsNullOrUndefinedToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberGreaterThan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberGreaterThanToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberIn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberIn | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberInRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberInRangeToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberInRange | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberLessThan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberLessThanToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberLessThan | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberLessThanOrEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberNotIn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberNotInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberNotIn | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterNumberNotInRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberNotInRangeToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberNotInRange | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringBeginsWith {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringBeginsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringBeginsWith | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringContains {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringContainsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringContains | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringEndsWith {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringEndsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringEndsWith | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringIn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringIn | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotBeginsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringNotContains {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotContainsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotContains | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringNotEndsWith {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotEndsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilterStringNotIn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}
    */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotIn | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionAdvancedFilter {
    /**
    * bool_equals block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#bool_equals EventgridEventSubscription#bool_equals}
    */
    readonly boolEquals?: EventgridEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable;
    /**
    * is_not_null block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#is_not_null EventgridEventSubscription#is_not_null}
    */
    readonly isNotNull?: EventgridEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable;
    /**
    * is_null_or_undefined block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#is_null_or_undefined EventgridEventSubscription#is_null_or_undefined}
    */
    readonly isNullOrUndefined?: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable;
    /**
    * number_greater_than block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_greater_than EventgridEventSubscription#number_greater_than}
    */
    readonly numberGreaterThan?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable;
    /**
    * number_greater_than_or_equals block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_greater_than_or_equals EventgridEventSubscription#number_greater_than_or_equals}
    */
    readonly numberGreaterThanOrEquals?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable;
    /**
    * number_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_in EventgridEventSubscription#number_in}
    */
    readonly numberIn?: EventgridEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable;
    /**
    * number_in_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_in_range EventgridEventSubscription#number_in_range}
    */
    readonly numberInRange?: EventgridEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable;
    /**
    * number_less_than block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_less_than EventgridEventSubscription#number_less_than}
    */
    readonly numberLessThan?: EventgridEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable;
    /**
    * number_less_than_or_equals block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_less_than_or_equals EventgridEventSubscription#number_less_than_or_equals}
    */
    readonly numberLessThanOrEquals?: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable;
    /**
    * number_not_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_not_in EventgridEventSubscription#number_not_in}
    */
    readonly numberNotIn?: EventgridEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable;
    /**
    * number_not_in_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_not_in_range EventgridEventSubscription#number_not_in_range}
    */
    readonly numberNotInRange?: EventgridEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable;
    /**
    * string_begins_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_begins_with EventgridEventSubscription#string_begins_with}
    */
    readonly stringBeginsWith?: EventgridEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable;
    /**
    * string_contains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_contains EventgridEventSubscription#string_contains}
    */
    readonly stringContains?: EventgridEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable;
    /**
    * string_ends_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_ends_with EventgridEventSubscription#string_ends_with}
    */
    readonly stringEndsWith?: EventgridEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable;
    /**
    * string_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_in EventgridEventSubscription#string_in}
    */
    readonly stringIn?: EventgridEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable;
    /**
    * string_not_begins_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_begins_with EventgridEventSubscription#string_not_begins_with}
    */
    readonly stringNotBeginsWith?: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable;
    /**
    * string_not_contains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_contains EventgridEventSubscription#string_not_contains}
    */
    readonly stringNotContains?: EventgridEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable;
    /**
    * string_not_ends_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_ends_with EventgridEventSubscription#string_not_ends_with}
    */
    readonly stringNotEndsWith?: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable;
    /**
    * string_not_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_in EventgridEventSubscription#string_not_in}
    */
    readonly stringNotIn?: EventgridEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable;
}
export declare function eventgridEventSubscriptionAdvancedFilterToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterOutputReference | EventgridEventSubscriptionAdvancedFilter): any;
export declare class EventgridEventSubscriptionAdvancedFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionAdvancedFilter | undefined;
    set internalValue(value: EventgridEventSubscriptionAdvancedFilter | undefined);
    private _boolEquals?;
    get boolEquals(): EventgridEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable;
    set boolEquals(value: EventgridEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable);
    resetBoolEquals(): void;
    get boolEqualsInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterBoolEquals[] | undefined;
    private _isNotNull?;
    get isNotNull(): EventgridEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable;
    set isNotNull(value: EventgridEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable);
    resetIsNotNull(): void;
    get isNotNullInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterIsNotNull[] | undefined;
    private _isNullOrUndefined?;
    get isNullOrUndefined(): EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable;
    set isNullOrUndefined(value: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable);
    resetIsNullOrUndefined(): void;
    get isNullOrUndefinedInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[] | undefined;
    private _numberGreaterThan?;
    get numberGreaterThan(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable;
    set numberGreaterThan(value: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable);
    resetNumberGreaterThan(): void;
    get numberGreaterThanInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[] | undefined;
    private _numberGreaterThanOrEquals?;
    get numberGreaterThanOrEquals(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable;
    set numberGreaterThanOrEquals(value: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable);
    resetNumberGreaterThanOrEquals(): void;
    get numberGreaterThanOrEqualsInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | undefined;
    private _numberIn?;
    get numberIn(): EventgridEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable;
    set numberIn(value: EventgridEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable);
    resetNumberIn(): void;
    get numberInInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberIn[] | undefined;
    private _numberInRange?;
    get numberInRange(): EventgridEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable;
    set numberInRange(value: EventgridEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable);
    resetNumberInRange(): void;
    get numberInRangeInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberInRange[] | undefined;
    private _numberLessThan?;
    get numberLessThan(): EventgridEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable;
    set numberLessThan(value: EventgridEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable);
    resetNumberLessThan(): void;
    get numberLessThanInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberLessThan[] | undefined;
    private _numberLessThanOrEquals?;
    get numberLessThanOrEquals(): EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable;
    set numberLessThanOrEquals(value: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable);
    resetNumberLessThanOrEquals(): void;
    get numberLessThanOrEqualsInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | undefined;
    private _numberNotIn?;
    get numberNotIn(): EventgridEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable;
    set numberNotIn(value: EventgridEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable);
    resetNumberNotIn(): void;
    get numberNotInInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberNotIn[] | undefined;
    private _numberNotInRange?;
    get numberNotInRange(): EventgridEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable;
    set numberNotInRange(value: EventgridEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable);
    resetNumberNotInRange(): void;
    get numberNotInRangeInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterNumberNotInRange[] | undefined;
    private _stringBeginsWith?;
    get stringBeginsWith(): EventgridEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable;
    set stringBeginsWith(value: EventgridEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable);
    resetStringBeginsWith(): void;
    get stringBeginsWithInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringBeginsWith[] | undefined;
    private _stringContains?;
    get stringContains(): EventgridEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable;
    set stringContains(value: EventgridEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable);
    resetStringContains(): void;
    get stringContainsInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringContains[] | undefined;
    private _stringEndsWith?;
    get stringEndsWith(): EventgridEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable;
    set stringEndsWith(value: EventgridEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable);
    resetStringEndsWith(): void;
    get stringEndsWithInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringEndsWith[] | undefined;
    private _stringIn?;
    get stringIn(): EventgridEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable;
    set stringIn(value: EventgridEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable);
    resetStringIn(): void;
    get stringInInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringIn[] | undefined;
    private _stringNotBeginsWith?;
    get stringNotBeginsWith(): EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable;
    set stringNotBeginsWith(value: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable);
    resetStringNotBeginsWith(): void;
    get stringNotBeginsWithInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[] | undefined;
    private _stringNotContains?;
    get stringNotContains(): EventgridEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable;
    set stringNotContains(value: EventgridEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable);
    resetStringNotContains(): void;
    get stringNotContainsInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringNotContains[] | undefined;
    private _stringNotEndsWith?;
    get stringNotEndsWith(): EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable;
    set stringNotEndsWith(value: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable);
    resetStringNotEndsWith(): void;
    get stringNotEndsWithInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[] | undefined;
    private _stringNotIn?;
    get stringNotIn(): EventgridEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable;
    set stringNotIn(value: EventgridEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable);
    resetStringNotIn(): void;
    get stringNotInInput(): cdktf.IResolvable | EventgridEventSubscriptionAdvancedFilterStringNotIn[] | undefined;
}
export interface EventgridEventSubscriptionAzureFunctionEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#function_id EventgridEventSubscription#function_id}
    */
    readonly functionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_events_per_batch EventgridEventSubscription#max_events_per_batch}
    */
    readonly maxEventsPerBatch?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#preferred_batch_size_in_kilobytes EventgridEventSubscription#preferred_batch_size_in_kilobytes}
    */
    readonly preferredBatchSizeInKilobytes?: number;
}
export declare function eventgridEventSubscriptionAzureFunctionEndpointToTerraform(struct?: EventgridEventSubscriptionAzureFunctionEndpointOutputReference | EventgridEventSubscriptionAzureFunctionEndpoint): any;
export declare class EventgridEventSubscriptionAzureFunctionEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionAzureFunctionEndpoint | undefined;
    set internalValue(value: EventgridEventSubscriptionAzureFunctionEndpoint | undefined);
    private _functionId?;
    get functionId(): string;
    set functionId(value: string);
    get functionIdInput(): string | undefined;
    private _maxEventsPerBatch?;
    get maxEventsPerBatch(): number;
    set maxEventsPerBatch(value: number);
    resetMaxEventsPerBatch(): void;
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    get preferredBatchSizeInKilobytes(): number;
    set preferredBatchSizeInKilobytes(value: number);
    resetPreferredBatchSizeInKilobytes(): void;
    get preferredBatchSizeInKilobytesInput(): number | undefined;
}
export interface EventgridEventSubscriptionDeadLetterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#user_assigned_identity EventgridEventSubscription#user_assigned_identity}
    */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridEventSubscriptionDeadLetterIdentityToTerraform(struct?: EventgridEventSubscriptionDeadLetterIdentityOutputReference | EventgridEventSubscriptionDeadLetterIdentity): any;
export declare class EventgridEventSubscriptionDeadLetterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionDeadLetterIdentity | undefined;
    set internalValue(value: EventgridEventSubscriptionDeadLetterIdentity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    get userAssignedIdentity(): string;
    set userAssignedIdentity(value: string);
    resetUserAssignedIdentity(): void;
    get userAssignedIdentityInput(): string | undefined;
}
export interface EventgridEventSubscriptionDeliveryIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#user_assigned_identity EventgridEventSubscription#user_assigned_identity}
    */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridEventSubscriptionDeliveryIdentityToTerraform(struct?: EventgridEventSubscriptionDeliveryIdentityOutputReference | EventgridEventSubscriptionDeliveryIdentity): any;
export declare class EventgridEventSubscriptionDeliveryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionDeliveryIdentity | undefined;
    set internalValue(value: EventgridEventSubscriptionDeliveryIdentity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    get userAssignedIdentity(): string;
    set userAssignedIdentity(value: string);
    resetUserAssignedIdentity(): void;
    get userAssignedIdentityInput(): string | undefined;
}
export interface EventgridEventSubscriptionDeliveryProperty {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#header_name EventgridEventSubscription#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#secret EventgridEventSubscription#secret}
    */
    readonly secret?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#source_field EventgridEventSubscription#source_field}
    */
    readonly sourceField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}
    */
    readonly value?: string;
}
export declare function eventgridEventSubscriptionDeliveryPropertyToTerraform(struct?: EventgridEventSubscriptionDeliveryProperty | cdktf.IResolvable): any;
export interface EventgridEventSubscriptionEventhubEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_id EventgridEventSubscription#eventhub_id}
    */
    readonly eventhubId?: string;
}
export declare function eventgridEventSubscriptionEventhubEndpointToTerraform(struct?: EventgridEventSubscriptionEventhubEndpointOutputReference | EventgridEventSubscriptionEventhubEndpoint): any;
export declare class EventgridEventSubscriptionEventhubEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionEventhubEndpoint | undefined;
    set internalValue(value: EventgridEventSubscriptionEventhubEndpoint | undefined);
    private _eventhubId?;
    get eventhubId(): string;
    set eventhubId(value: string);
    resetEventhubId(): void;
    get eventhubIdInput(): string | undefined;
}
export interface EventgridEventSubscriptionHybridConnectionEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_id EventgridEventSubscription#hybrid_connection_id}
    */
    readonly hybridConnectionId?: string;
}
export declare function eventgridEventSubscriptionHybridConnectionEndpointToTerraform(struct?: EventgridEventSubscriptionHybridConnectionEndpointOutputReference | EventgridEventSubscriptionHybridConnectionEndpoint): any;
export declare class EventgridEventSubscriptionHybridConnectionEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionHybridConnectionEndpoint | undefined;
    set internalValue(value: EventgridEventSubscriptionHybridConnectionEndpoint | undefined);
    private _hybridConnectionId?;
    get hybridConnectionId(): string;
    set hybridConnectionId(value: string);
    resetHybridConnectionId(): void;
    get hybridConnectionIdInput(): string | undefined;
}
export interface EventgridEventSubscriptionRetryPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#event_time_to_live EventgridEventSubscription#event_time_to_live}
    */
    readonly eventTimeToLive: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_delivery_attempts EventgridEventSubscription#max_delivery_attempts}
    */
    readonly maxDeliveryAttempts: number;
}
export declare function eventgridEventSubscriptionRetryPolicyToTerraform(struct?: EventgridEventSubscriptionRetryPolicyOutputReference | EventgridEventSubscriptionRetryPolicy): any;
export declare class EventgridEventSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionRetryPolicy | undefined;
    set internalValue(value: EventgridEventSubscriptionRetryPolicy | undefined);
    private _eventTimeToLive?;
    get eventTimeToLive(): number;
    set eventTimeToLive(value: number);
    get eventTimeToLiveInput(): number | undefined;
    private _maxDeliveryAttempts?;
    get maxDeliveryAttempts(): number;
    set maxDeliveryAttempts(value: number);
    get maxDeliveryAttemptsInput(): number | undefined;
}
export interface EventgridEventSubscriptionStorageBlobDeadLetterDestination {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_account_id EventgridEventSubscription#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_blob_container_name EventgridEventSubscription#storage_blob_container_name}
    */
    readonly storageBlobContainerName: string;
}
export declare function eventgridEventSubscriptionStorageBlobDeadLetterDestinationToTerraform(struct?: EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference | EventgridEventSubscriptionStorageBlobDeadLetterDestination): any;
export declare class EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    set internalValue(value: EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined);
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _storageBlobContainerName?;
    get storageBlobContainerName(): string;
    set storageBlobContainerName(value: string);
    get storageBlobContainerNameInput(): string | undefined;
}
export interface EventgridEventSubscriptionStorageQueueEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#queue_message_time_to_live_in_seconds EventgridEventSubscription#queue_message_time_to_live_in_seconds}
    */
    readonly queueMessageTimeToLiveInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#queue_name EventgridEventSubscription#queue_name}
    */
    readonly queueName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_account_id EventgridEventSubscription#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function eventgridEventSubscriptionStorageQueueEndpointToTerraform(struct?: EventgridEventSubscriptionStorageQueueEndpointOutputReference | EventgridEventSubscriptionStorageQueueEndpoint): any;
export declare class EventgridEventSubscriptionStorageQueueEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionStorageQueueEndpoint | undefined;
    set internalValue(value: EventgridEventSubscriptionStorageQueueEndpoint | undefined);
    private _queueMessageTimeToLiveInSeconds?;
    get queueMessageTimeToLiveInSeconds(): number;
    set queueMessageTimeToLiveInSeconds(value: number);
    resetQueueMessageTimeToLiveInSeconds(): void;
    get queueMessageTimeToLiveInSecondsInput(): number | undefined;
    private _queueName?;
    get queueName(): string;
    set queueName(value: string);
    get queueNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export interface EventgridEventSubscriptionSubjectFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#case_sensitive EventgridEventSubscription#case_sensitive}
    */
    readonly caseSensitive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_begins_with EventgridEventSubscription#subject_begins_with}
    */
    readonly subjectBeginsWith?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_ends_with EventgridEventSubscription#subject_ends_with}
    */
    readonly subjectEndsWith?: string;
}
export declare function eventgridEventSubscriptionSubjectFilterToTerraform(struct?: EventgridEventSubscriptionSubjectFilterOutputReference | EventgridEventSubscriptionSubjectFilter): any;
export declare class EventgridEventSubscriptionSubjectFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionSubjectFilter | undefined;
    set internalValue(value: EventgridEventSubscriptionSubjectFilter | undefined);
    private _caseSensitive?;
    get caseSensitive(): boolean | cdktf.IResolvable;
    set caseSensitive(value: boolean | cdktf.IResolvable);
    resetCaseSensitive(): void;
    get caseSensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _subjectBeginsWith?;
    get subjectBeginsWith(): string;
    set subjectBeginsWith(value: string);
    resetSubjectBeginsWith(): void;
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    get subjectEndsWith(): string;
    set subjectEndsWith(value: string);
    resetSubjectEndsWith(): void;
    get subjectEndsWithInput(): string | undefined;
}
export interface EventgridEventSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#create EventgridEventSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delete EventgridEventSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#read EventgridEventSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#update EventgridEventSubscription#update}
    */
    readonly update?: string;
}
export declare function eventgridEventSubscriptionTimeoutsToTerraform(struct?: EventgridEventSubscriptionTimeoutsOutputReference | EventgridEventSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class EventgridEventSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionTimeouts | undefined;
    set internalValue(value: EventgridEventSubscriptionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface EventgridEventSubscriptionWebhookEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#active_directory_app_id_or_uri EventgridEventSubscription#active_directory_app_id_or_uri}
    */
    readonly activeDirectoryAppIdOrUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#active_directory_tenant_id EventgridEventSubscription#active_directory_tenant_id}
    */
    readonly activeDirectoryTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_events_per_batch EventgridEventSubscription#max_events_per_batch}
    */
    readonly maxEventsPerBatch?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#preferred_batch_size_in_kilobytes EventgridEventSubscription#preferred_batch_size_in_kilobytes}
    */
    readonly preferredBatchSizeInKilobytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#url EventgridEventSubscription#url}
    */
    readonly url: string;
}
export declare function eventgridEventSubscriptionWebhookEndpointToTerraform(struct?: EventgridEventSubscriptionWebhookEndpointOutputReference | EventgridEventSubscriptionWebhookEndpoint): any;
export declare class EventgridEventSubscriptionWebhookEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventgridEventSubscriptionWebhookEndpoint | undefined;
    set internalValue(value: EventgridEventSubscriptionWebhookEndpoint | undefined);
    private _activeDirectoryAppIdOrUri?;
    get activeDirectoryAppIdOrUri(): string;
    set activeDirectoryAppIdOrUri(value: string);
    resetActiveDirectoryAppIdOrUri(): void;
    get activeDirectoryAppIdOrUriInput(): string | undefined;
    private _activeDirectoryTenantId?;
    get activeDirectoryTenantId(): string;
    set activeDirectoryTenantId(value: string);
    resetActiveDirectoryTenantId(): void;
    get activeDirectoryTenantIdInput(): string | undefined;
    get baseUrl(): string;
    private _maxEventsPerBatch?;
    get maxEventsPerBatch(): number;
    set maxEventsPerBatch(value: number);
    resetMaxEventsPerBatch(): void;
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    get preferredBatchSizeInKilobytes(): number;
    set preferredBatchSizeInKilobytes(value: number);
    resetPreferredBatchSizeInKilobytes(): void;
    get preferredBatchSizeInKilobytesInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription azurerm_eventgrid_event_subscription}
*/
export declare class EventgridEventSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription azurerm_eventgrid_event_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridEventSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: EventgridEventSubscriptionConfig);
    private _advancedFilteringOnArraysEnabled?;
    get advancedFilteringOnArraysEnabled(): boolean | cdktf.IResolvable;
    set advancedFilteringOnArraysEnabled(value: boolean | cdktf.IResolvable);
    resetAdvancedFilteringOnArraysEnabled(): void;
    get advancedFilteringOnArraysEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eventDeliverySchema?;
    get eventDeliverySchema(): string;
    set eventDeliverySchema(value: string);
    resetEventDeliverySchema(): void;
    get eventDeliverySchemaInput(): string | undefined;
    private _eventhubEndpointId?;
    get eventhubEndpointId(): string;
    set eventhubEndpointId(value: string);
    resetEventhubEndpointId(): void;
    get eventhubEndpointIdInput(): string | undefined;
    private _expirationTimeUtc?;
    get expirationTimeUtc(): string;
    set expirationTimeUtc(value: string);
    resetExpirationTimeUtc(): void;
    get expirationTimeUtcInput(): string | undefined;
    private _hybridConnectionEndpointId?;
    get hybridConnectionEndpointId(): string;
    set hybridConnectionEndpointId(value: string);
    resetHybridConnectionEndpointId(): void;
    get hybridConnectionEndpointIdInput(): string | undefined;
    get id(): string;
    private _includedEventTypes?;
    get includedEventTypes(): string[];
    set includedEventTypes(value: string[]);
    resetIncludedEventTypes(): void;
    get includedEventTypesInput(): string[] | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _serviceBusQueueEndpointId?;
    get serviceBusQueueEndpointId(): string;
    set serviceBusQueueEndpointId(value: string);
    resetServiceBusQueueEndpointId(): void;
    get serviceBusQueueEndpointIdInput(): string | undefined;
    private _serviceBusTopicEndpointId?;
    get serviceBusTopicEndpointId(): string;
    set serviceBusTopicEndpointId(value: string);
    resetServiceBusTopicEndpointId(): void;
    get serviceBusTopicEndpointIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _advancedFilter;
    get advancedFilter(): EventgridEventSubscriptionAdvancedFilterOutputReference;
    putAdvancedFilter(value: EventgridEventSubscriptionAdvancedFilter): void;
    resetAdvancedFilter(): void;
    get advancedFilterInput(): EventgridEventSubscriptionAdvancedFilter | undefined;
    private _azureFunctionEndpoint;
    get azureFunctionEndpoint(): EventgridEventSubscriptionAzureFunctionEndpointOutputReference;
    putAzureFunctionEndpoint(value: EventgridEventSubscriptionAzureFunctionEndpoint): void;
    resetAzureFunctionEndpoint(): void;
    get azureFunctionEndpointInput(): EventgridEventSubscriptionAzureFunctionEndpoint | undefined;
    private _deadLetterIdentity;
    get deadLetterIdentity(): EventgridEventSubscriptionDeadLetterIdentityOutputReference;
    putDeadLetterIdentity(value: EventgridEventSubscriptionDeadLetterIdentity): void;
    resetDeadLetterIdentity(): void;
    get deadLetterIdentityInput(): EventgridEventSubscriptionDeadLetterIdentity | undefined;
    private _deliveryIdentity;
    get deliveryIdentity(): EventgridEventSubscriptionDeliveryIdentityOutputReference;
    putDeliveryIdentity(value: EventgridEventSubscriptionDeliveryIdentity): void;
    resetDeliveryIdentity(): void;
    get deliveryIdentityInput(): EventgridEventSubscriptionDeliveryIdentity | undefined;
    private _deliveryProperty?;
    get deliveryProperty(): EventgridEventSubscriptionDeliveryProperty[] | cdktf.IResolvable;
    set deliveryProperty(value: EventgridEventSubscriptionDeliveryProperty[] | cdktf.IResolvable);
    resetDeliveryProperty(): void;
    get deliveryPropertyInput(): cdktf.IResolvable | EventgridEventSubscriptionDeliveryProperty[] | undefined;
    private _eventhubEndpoint;
    get eventhubEndpoint(): EventgridEventSubscriptionEventhubEndpointOutputReference;
    putEventhubEndpoint(value: EventgridEventSubscriptionEventhubEndpoint): void;
    resetEventhubEndpoint(): void;
    get eventhubEndpointInput(): EventgridEventSubscriptionEventhubEndpoint | undefined;
    private _hybridConnectionEndpoint;
    get hybridConnectionEndpoint(): EventgridEventSubscriptionHybridConnectionEndpointOutputReference;
    putHybridConnectionEndpoint(value: EventgridEventSubscriptionHybridConnectionEndpoint): void;
    resetHybridConnectionEndpoint(): void;
    get hybridConnectionEndpointInput(): EventgridEventSubscriptionHybridConnectionEndpoint | undefined;
    private _retryPolicy;
    get retryPolicy(): EventgridEventSubscriptionRetryPolicyOutputReference;
    putRetryPolicy(value: EventgridEventSubscriptionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): EventgridEventSubscriptionRetryPolicy | undefined;
    private _storageBlobDeadLetterDestination;
    get storageBlobDeadLetterDestination(): EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference;
    putStorageBlobDeadLetterDestination(value: EventgridEventSubscriptionStorageBlobDeadLetterDestination): void;
    resetStorageBlobDeadLetterDestination(): void;
    get storageBlobDeadLetterDestinationInput(): EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    private _storageQueueEndpoint;
    get storageQueueEndpoint(): EventgridEventSubscriptionStorageQueueEndpointOutputReference;
    putStorageQueueEndpoint(value: EventgridEventSubscriptionStorageQueueEndpoint): void;
    resetStorageQueueEndpoint(): void;
    get storageQueueEndpointInput(): EventgridEventSubscriptionStorageQueueEndpoint | undefined;
    private _subjectFilter;
    get subjectFilter(): EventgridEventSubscriptionSubjectFilterOutputReference;
    putSubjectFilter(value: EventgridEventSubscriptionSubjectFilter): void;
    resetSubjectFilter(): void;
    get subjectFilterInput(): EventgridEventSubscriptionSubjectFilter | undefined;
    private _timeouts;
    get timeouts(): EventgridEventSubscriptionTimeoutsOutputReference;
    putTimeouts(value: EventgridEventSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EventgridEventSubscriptionTimeouts | undefined;
    private _webhookEndpoint;
    get webhookEndpoint(): EventgridEventSubscriptionWebhookEndpointOutputReference;
    putWebhookEndpoint(value: EventgridEventSubscriptionWebhookEndpoint): void;
    resetWebhookEndpoint(): void;
    get webhookEndpointInput(): EventgridEventSubscriptionWebhookEndpoint | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
