import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventhubNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#auto_inflate_enabled EventhubNamespace#auto_inflate_enabled}
    */
    readonly autoInflateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#capacity EventhubNamespace#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#dedicated_cluster_id EventhubNamespace#dedicated_cluster_id}
    */
    readonly dedicatedClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#location EventhubNamespace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#maximum_throughput_units EventhubNamespace#maximum_throughput_units}
    */
    readonly maximumThroughputUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#name EventhubNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#network_rulesets EventhubNamespace#network_rulesets}
    */
    readonly networkRulesets?: EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#resource_group_name EventhubNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#sku EventhubNamespace#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#tags EventhubNamespace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#zone_redundant EventhubNamespace#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#identity EventhubNamespace#identity}
    */
    readonly identity?: EventhubNamespaceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#timeouts EventhubNamespace#timeouts}
    */
    readonly timeouts?: EventhubNamespaceTimeouts;
}
export interface EventhubNamespaceNetworkRulesetsIpRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#action EventhubNamespace#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#ip_mask EventhubNamespace#ip_mask}
    */
    readonly ipMask?: string;
}
export declare function eventhubNamespaceNetworkRulesetsIpRuleToTerraform(struct?: EventhubNamespaceNetworkRulesetsIpRule | cdktf.IResolvable): any;
export interface EventhubNamespaceNetworkRulesetsVirtualNetworkRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#ignore_missing_virtual_network_service_endpoint EventhubNamespace#ignore_missing_virtual_network_service_endpoint}
    */
    readonly ignoreMissingVirtualNetworkServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#subnet_id EventhubNamespace#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function eventhubNamespaceNetworkRulesetsVirtualNetworkRuleToTerraform(struct?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule | cdktf.IResolvable): any;
export interface EventhubNamespaceNetworkRulesets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#default_action EventhubNamespace#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#ip_rule EventhubNamespace#ip_rule}
    */
    readonly ipRule?: EventhubNamespaceNetworkRulesetsIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#trusted_service_access_enabled EventhubNamespace#trusted_service_access_enabled}
    */
    readonly trustedServiceAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#virtual_network_rule EventhubNamespace#virtual_network_rule}
    */
    readonly virtualNetworkRule?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule[] | cdktf.IResolvable;
}
export declare function eventhubNamespaceNetworkRulesetsToTerraform(struct?: EventhubNamespaceNetworkRulesets | cdktf.IResolvable): any;
export interface EventhubNamespaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#type EventhubNamespace#type}
    */
    readonly type: string;
}
export declare function eventhubNamespaceIdentityToTerraform(struct?: EventhubNamespaceIdentityOutputReference | EventhubNamespaceIdentity): any;
export declare class EventhubNamespaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventhubNamespaceIdentity | undefined;
    set internalValue(value: EventhubNamespaceIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventhubNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#create EventhubNamespace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#delete EventhubNamespace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#read EventhubNamespace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace#update EventhubNamespace#update}
    */
    readonly update?: string;
}
export declare function eventhubNamespaceTimeoutsToTerraform(struct?: EventhubNamespaceTimeoutsOutputReference | EventhubNamespaceTimeouts | cdktf.IResolvable): any;
export declare class EventhubNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EventhubNamespaceTimeouts | undefined;
    set internalValue(value: EventhubNamespaceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace azurerm_eventhub_namespace}
*/
export declare class EventhubNamespace extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace azurerm_eventhub_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventhubNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: EventhubNamespaceConfig);
    private _autoInflateEnabled?;
    get autoInflateEnabled(): boolean | cdktf.IResolvable;
    set autoInflateEnabled(value: boolean | cdktf.IResolvable);
    resetAutoInflateEnabled(): void;
    get autoInflateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _dedicatedClusterId?;
    get dedicatedClusterId(): string;
    set dedicatedClusterId(value: string);
    resetDedicatedClusterId(): void;
    get dedicatedClusterIdInput(): string | undefined;
    get defaultPrimaryConnectionString(): string;
    get defaultPrimaryConnectionStringAlias(): string;
    get defaultPrimaryKey(): string;
    get defaultSecondaryConnectionString(): string;
    get defaultSecondaryConnectionStringAlias(): string;
    get defaultSecondaryKey(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maximumThroughputUnits?;
    get maximumThroughputUnits(): number;
    set maximumThroughputUnits(value: number);
    resetMaximumThroughputUnits(): void;
    get maximumThroughputUnitsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRulesets?;
    get networkRulesets(): EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable;
    set networkRulesets(value: EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable);
    resetNetworkRulesets(): void;
    get networkRulesetsInput(): cdktf.IResolvable | EventhubNamespaceNetworkRulesets[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _identity;
    get identity(): EventhubNamespaceIdentityOutputReference;
    putIdentity(value: EventhubNamespaceIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventhubNamespaceIdentity | undefined;
    private _timeouts;
    get timeouts(): EventhubNamespaceTimeoutsOutputReference;
    putTimeouts(value: EventhubNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EventhubNamespaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
