import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightKafkaClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#cluster_version HdinsightKafkaCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#encryption_in_transit_enabled HdinsightKafkaCluster#encryption_in_transit_enabled}
    */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#location HdinsightKafkaCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#resource_group_name HdinsightKafkaCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#tags HdinsightKafkaCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#tier HdinsightKafkaCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#tls_min_version HdinsightKafkaCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#component_version HdinsightKafkaCluster#component_version}
    */
    readonly componentVersion: HdinsightKafkaClusterComponentVersion;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#gateway HdinsightKafkaCluster#gateway}
    */
    readonly gateway: HdinsightKafkaClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#metastores HdinsightKafkaCluster#metastores}
    */
    readonly metastores?: HdinsightKafkaClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#monitor HdinsightKafkaCluster#monitor}
    */
    readonly monitor?: HdinsightKafkaClusterMonitor;
    /**
    * rest_proxy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#rest_proxy HdinsightKafkaCluster#rest_proxy}
    */
    readonly restProxy?: HdinsightKafkaClusterRestProxy;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#roles HdinsightKafkaCluster#roles}
    */
    readonly roles: HdinsightKafkaClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#security_profile HdinsightKafkaCluster#security_profile}
    */
    readonly securityProfile?: HdinsightKafkaClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_account HdinsightKafkaCluster#storage_account}
    */
    readonly storageAccount?: HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_account_gen2 HdinsightKafkaCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightKafkaClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#timeouts HdinsightKafkaCluster#timeouts}
    */
    readonly timeouts?: HdinsightKafkaClusterTimeouts;
}
export interface HdinsightKafkaClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#kafka HdinsightKafkaCluster#kafka}
    */
    readonly kafka: string;
}
export declare function hdinsightKafkaClusterComponentVersionToTerraform(struct?: HdinsightKafkaClusterComponentVersionOutputReference | HdinsightKafkaClusterComponentVersion): any;
export declare class HdinsightKafkaClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterComponentVersion | undefined;
    set internalValue(value: HdinsightKafkaClusterComponentVersion | undefined);
    private _kafka?;
    get kafka(): string;
    set kafka(value: string);
    get kafkaInput(): string | undefined;
}
export interface HdinsightKafkaClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#enabled HdinsightKafkaCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterGatewayToTerraform(struct?: HdinsightKafkaClusterGatewayOutputReference | HdinsightKafkaClusterGateway): any;
export declare class HdinsightKafkaClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterGateway | undefined;
    set internalValue(value: HdinsightKafkaClusterGateway | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresAmbariToTerraform(struct?: HdinsightKafkaClusterMetastoresAmbariOutputReference | HdinsightKafkaClusterMetastoresAmbari): any;
export declare class HdinsightKafkaClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresHiveToTerraform(struct?: HdinsightKafkaClusterMetastoresHiveOutputReference | HdinsightKafkaClusterMetastoresHive): any;
export declare class HdinsightKafkaClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresOozieToTerraform(struct?: HdinsightKafkaClusterMetastoresOozieOutputReference | HdinsightKafkaClusterMetastoresOozie): any;
export declare class HdinsightKafkaClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ambari HdinsightKafkaCluster#ambari}
    */
    readonly ambari?: HdinsightKafkaClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#hive HdinsightKafkaCluster#hive}
    */
    readonly hive?: HdinsightKafkaClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#oozie HdinsightKafkaCluster#oozie}
    */
    readonly oozie?: HdinsightKafkaClusterMetastoresOozie;
}
export declare function hdinsightKafkaClusterMetastoresToTerraform(struct?: HdinsightKafkaClusterMetastoresOutputReference | HdinsightKafkaClusterMetastores): any;
export declare class HdinsightKafkaClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterMetastores | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightKafkaClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightKafkaClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightKafkaClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightKafkaClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightKafkaClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightKafkaClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightKafkaClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightKafkaClusterMetastoresOozie | undefined;
}
export interface HdinsightKafkaClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#log_analytics_workspace_id HdinsightKafkaCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#primary_key HdinsightKafkaCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightKafkaClusterMonitorToTerraform(struct?: HdinsightKafkaClusterMonitorOutputReference | HdinsightKafkaClusterMonitor): any;
export declare class HdinsightKafkaClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterMonitor | undefined;
    set internalValue(value: HdinsightKafkaClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightKafkaClusterRestProxy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#security_group_id HdinsightKafkaCluster#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#security_group_name HdinsightKafkaCluster#security_group_name}
    */
    readonly securityGroupName?: string;
}
export declare function hdinsightKafkaClusterRestProxyToTerraform(struct?: HdinsightKafkaClusterRestProxyOutputReference | HdinsightKafkaClusterRestProxy): any;
export declare class HdinsightKafkaClusterRestProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRestProxy | undefined;
    set internalValue(value: HdinsightKafkaClusterRestProxy | undefined);
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _securityGroupName?;
    get securityGroupName(): string;
    set securityGroupName(value: string);
    resetSecurityGroupName(): void;
    get securityGroupNameInput(): string | undefined;
}
export interface HdinsightKafkaClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesHeadNodeToTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeOutputReference | HdinsightKafkaClusterRolesHeadNode): any;
export declare class HdinsightKafkaClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightKafkaClusterRolesKafkaManagementNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeToTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference | HdinsightKafkaClusterRolesKafkaManagementNode): any;
export declare class HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesKafkaManagementNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightKafkaClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#min_instance_count HdinsightKafkaCluster#min_instance_count}
    */
    readonly minInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#number_of_disks_per_node HdinsightKafkaCluster#number_of_disks_per_node}
    */
    readonly numberOfDisksPerNode: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#target_instance_count HdinsightKafkaCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesWorkerNodeToTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeOutputReference | HdinsightKafkaClusterRolesWorkerNode): any;
export declare class HdinsightKafkaClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
    private _numberOfDisksPerNode?;
    get numberOfDisksPerNode(): number;
    set numberOfDisksPerNode(value: number);
    get numberOfDisksPerNodeInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightKafkaClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesZookeeperNodeToTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeOutputReference | HdinsightKafkaClusterRolesZookeeperNode): any;
export declare class HdinsightKafkaClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightKafkaClusterRoles {
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#head_node HdinsightKafkaCluster#head_node}
    */
    readonly headNode: HdinsightKafkaClusterRolesHeadNode;
    /**
    * kafka_management_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#kafka_management_node HdinsightKafkaCluster#kafka_management_node}
    */
    readonly kafkaManagementNode?: HdinsightKafkaClusterRolesKafkaManagementNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#worker_node HdinsightKafkaCluster#worker_node}
    */
    readonly workerNode: HdinsightKafkaClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#zookeeper_node HdinsightKafkaCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightKafkaClusterRolesZookeeperNode;
}
export declare function hdinsightKafkaClusterRolesToTerraform(struct?: HdinsightKafkaClusterRolesOutputReference | HdinsightKafkaClusterRoles): any;
export declare class HdinsightKafkaClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterRoles | undefined;
    set internalValue(value: HdinsightKafkaClusterRoles | undefined);
    private _headNode;
    get headNode(): HdinsightKafkaClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightKafkaClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightKafkaClusterRolesHeadNode | undefined;
    private _kafkaManagementNode;
    get kafkaManagementNode(): HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference;
    putKafkaManagementNode(value: HdinsightKafkaClusterRolesKafkaManagementNode): void;
    resetKafkaManagementNode(): void;
    get kafkaManagementNodeInput(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightKafkaClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightKafkaClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightKafkaClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightKafkaClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
}
export interface HdinsightKafkaClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#aadds_resource_id HdinsightKafkaCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#cluster_users_group_dns HdinsightKafkaCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#domain_name HdinsightKafkaCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#domain_user_password HdinsightKafkaCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#domain_username HdinsightKafkaCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#ldaps_urls HdinsightKafkaCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#msi_resource_id HdinsightKafkaCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightKafkaClusterSecurityProfileToTerraform(struct?: HdinsightKafkaClusterSecurityProfileOutputReference | HdinsightKafkaClusterSecurityProfile): any;
export declare class HdinsightKafkaClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightKafkaClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightKafkaClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#is_default HdinsightKafkaCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_account_key HdinsightKafkaCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_container_id HdinsightKafkaCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_resource_id HdinsightKafkaCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightKafkaClusterStorageAccountToTerraform(struct?: HdinsightKafkaClusterStorageAccount | cdktf.IResolvable): any;
export interface HdinsightKafkaClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#filesystem_id HdinsightKafkaCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#is_default HdinsightKafkaCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#managed_identity_resource_id HdinsightKafkaCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#storage_resource_id HdinsightKafkaCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightKafkaClusterStorageAccountGen2ToTerraform(struct?: HdinsightKafkaClusterStorageAccountGen2OutputReference | HdinsightKafkaClusterStorageAccountGen2): any;
export declare class HdinsightKafkaClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightKafkaClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightKafkaClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#create HdinsightKafkaCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#delete HdinsightKafkaCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#read HdinsightKafkaCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster#update HdinsightKafkaCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightKafkaClusterTimeoutsToTerraform(struct?: HdinsightKafkaClusterTimeoutsOutputReference | HdinsightKafkaClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HdinsightKafkaClusterTimeouts | undefined;
    set internalValue(value: HdinsightKafkaClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster azurerm_hdinsight_kafka_cluster}
*/
export declare class HdinsightKafkaCluster extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster azurerm_hdinsight_kafka_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightKafkaClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightKafkaClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionInTransitEnabled(): void;
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get httpsEndpoint(): string;
    get id(): string;
    get kafkaRestProxyEndpoint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightKafkaClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightKafkaClusterComponentVersion): void;
    get componentVersionInput(): HdinsightKafkaClusterComponentVersion | undefined;
    private _gateway;
    get gateway(): HdinsightKafkaClusterGatewayOutputReference;
    putGateway(value: HdinsightKafkaClusterGateway): void;
    get gatewayInput(): HdinsightKafkaClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightKafkaClusterMetastoresOutputReference;
    putMetastores(value: HdinsightKafkaClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightKafkaClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightKafkaClusterMonitorOutputReference;
    putMonitor(value: HdinsightKafkaClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightKafkaClusterMonitor | undefined;
    private _restProxy;
    get restProxy(): HdinsightKafkaClusterRestProxyOutputReference;
    putRestProxy(value: HdinsightKafkaClusterRestProxy): void;
    resetRestProxy(): void;
    get restProxyInput(): HdinsightKafkaClusterRestProxy | undefined;
    private _roles;
    get roles(): HdinsightKafkaClusterRolesOutputReference;
    putRoles(value: HdinsightKafkaClusterRoles): void;
    get rolesInput(): HdinsightKafkaClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightKafkaClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightKafkaClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightKafkaClusterSecurityProfile | undefined;
    private _storageAccount?;
    get storageAccount(): HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable;
    set storageAccount(value: HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable);
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightKafkaClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightKafkaClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightKafkaClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightKafkaClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightKafkaClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): HdinsightKafkaClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
