import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IotTimeSeriesInsightsAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#description IotTimeSeriesInsightsAccessPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#name IotTimeSeriesInsightsAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#principal_object_id IotTimeSeriesInsightsAccessPolicy#principal_object_id}
    */
    readonly principalObjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#roles IotTimeSeriesInsightsAccessPolicy#roles}
    */
    readonly roles: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#time_series_insights_environment_id IotTimeSeriesInsightsAccessPolicy#time_series_insights_environment_id}
    */
    readonly timeSeriesInsightsEnvironmentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#timeouts IotTimeSeriesInsightsAccessPolicy#timeouts}
    */
    readonly timeouts?: IotTimeSeriesInsightsAccessPolicyTimeouts;
}
export interface IotTimeSeriesInsightsAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#create IotTimeSeriesInsightsAccessPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#delete IotTimeSeriesInsightsAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#read IotTimeSeriesInsightsAccessPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy#update IotTimeSeriesInsightsAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function iotTimeSeriesInsightsAccessPolicyTimeoutsToTerraform(struct?: IotTimeSeriesInsightsAccessPolicyTimeoutsOutputReference | IotTimeSeriesInsightsAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class IotTimeSeriesInsightsAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IotTimeSeriesInsightsAccessPolicyTimeouts | undefined;
    set internalValue(value: IotTimeSeriesInsightsAccessPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy azurerm_iot_time_series_insights_access_policy}
*/
export declare class IotTimeSeriesInsightsAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iot_time_series_insights_access_policy azurerm_iot_time_series_insights_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotTimeSeriesInsightsAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: IotTimeSeriesInsightsAccessPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _principalObjectId?;
    get principalObjectId(): string;
    set principalObjectId(value: string);
    get principalObjectIdInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
    private _timeSeriesInsightsEnvironmentId?;
    get timeSeriesInsightsEnvironmentId(): string;
    set timeSeriesInsightsEnvironmentId(value: string);
    get timeSeriesInsightsEnvironmentIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): IotTimeSeriesInsightsAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: IotTimeSeriesInsightsAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IotTimeSeriesInsightsAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
