import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#content_type KeyVaultSecret#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#expiration_date KeyVaultSecret#expiration_date}
    */
    readonly expirationDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#key_vault_id KeyVaultSecret#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#name KeyVaultSecret#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#not_before_date KeyVaultSecret#not_before_date}
    */
    readonly notBeforeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#tags KeyVaultSecret#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#value KeyVaultSecret#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#timeouts KeyVaultSecret#timeouts}
    */
    readonly timeouts?: KeyVaultSecretTimeouts;
}
export interface KeyVaultSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#create KeyVaultSecret#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#delete KeyVaultSecret#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#read KeyVaultSecret#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret#update KeyVaultSecret#update}
    */
    readonly update?: string;
}
export declare function keyVaultSecretTimeoutsToTerraform(struct?: KeyVaultSecretTimeoutsOutputReference | KeyVaultSecretTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KeyVaultSecretTimeouts | undefined;
    set internalValue(value: KeyVaultSecretTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret azurerm_key_vault_secret}
*/
export declare class KeyVaultSecret extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_secret azurerm_key_vault_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultSecretConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultSecretConfig);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    resetExpirationDate(): void;
    get expirationDateInput(): string | undefined;
    get id(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notBeforeDate?;
    get notBeforeDate(): string;
    set notBeforeDate(value: string);
    resetNotBeforeDate(): void;
    get notBeforeDateInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    get version(): string;
    get versionlessId(): string;
    private _timeouts;
    get timeouts(): KeyVaultSecretTimeoutsOutputReference;
    putTimeouts(value: KeyVaultSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KeyVaultSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
