"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesClusterNodePool = exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = exports.KubernetesClusterNodePoolTimeoutsOutputReference = exports.kubernetesClusterNodePoolTimeoutsToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = exports.KubernetesClusterNodePoolKubeletConfigOutputReference = exports.kubernetesClusterNodePoolKubeletConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesClusterNodePoolKubeletConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_unsafe_sysctls: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedUnsafeSysctls),
        container_log_max_line: cdktf.numberToTerraform(struct.containerLogMaxLine),
        container_log_max_size_mb: cdktf.numberToTerraform(struct.containerLogMaxSizeMb),
        cpu_cfs_quota_enabled: cdktf.booleanToTerraform(struct.cpuCfsQuotaEnabled),
        cpu_cfs_quota_period: cdktf.stringToTerraform(struct.cpuCfsQuotaPeriod),
        cpu_manager_policy: cdktf.stringToTerraform(struct.cpuManagerPolicy),
        image_gc_high_threshold: cdktf.numberToTerraform(struct.imageGcHighThreshold),
        image_gc_low_threshold: cdktf.numberToTerraform(struct.imageGcLowThreshold),
        pod_max_pid: cdktf.numberToTerraform(struct.podMaxPid),
        topology_manager_policy: cdktf.stringToTerraform(struct.topologyManagerPolicy),
    };
}
exports.kubernetesClusterNodePoolKubeletConfigToTerraform = kubernetesClusterNodePoolKubeletConfigToTerraform;
class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedUnsafeSysctls !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedUnsafeSysctls = this._allowedUnsafeSysctls;
        }
        if (this._containerLogMaxLine !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxLine = this._containerLogMaxLine;
        }
        if (this._containerLogMaxSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxSizeMb = this._containerLogMaxSizeMb;
        }
        if (this._cpuCfsQuotaEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaEnabled = this._cpuCfsQuotaEnabled;
        }
        if (this._cpuCfsQuotaPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaPeriod = this._cpuCfsQuotaPeriod;
        }
        if (this._cpuManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuManagerPolicy = this._cpuManagerPolicy;
        }
        if (this._imageGcHighThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcHighThreshold = this._imageGcHighThreshold;
        }
        if (this._imageGcLowThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcLowThreshold = this._imageGcLowThreshold;
        }
        if (this._podMaxPid !== undefined) {
            hasAnyValues = true;
            internalValueResult.podMaxPid = this._podMaxPid;
        }
        if (this._topologyManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.topologyManagerPolicy = this._topologyManagerPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedUnsafeSysctls = undefined;
            this._containerLogMaxLine = undefined;
            this._containerLogMaxSizeMb = undefined;
            this._cpuCfsQuotaEnabled = undefined;
            this._cpuCfsQuotaPeriod = undefined;
            this._cpuManagerPolicy = undefined;
            this._imageGcHighThreshold = undefined;
            this._imageGcLowThreshold = undefined;
            this._podMaxPid = undefined;
            this._topologyManagerPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedUnsafeSysctls = value.allowedUnsafeSysctls;
            this._containerLogMaxLine = value.containerLogMaxLine;
            this._containerLogMaxSizeMb = value.containerLogMaxSizeMb;
            this._cpuCfsQuotaEnabled = value.cpuCfsQuotaEnabled;
            this._cpuCfsQuotaPeriod = value.cpuCfsQuotaPeriod;
            this._cpuManagerPolicy = value.cpuManagerPolicy;
            this._imageGcHighThreshold = value.imageGcHighThreshold;
            this._imageGcLowThreshold = value.imageGcLowThreshold;
            this._podMaxPid = value.podMaxPid;
            this._topologyManagerPolicy = value.topologyManagerPolicy;
        }
    }
    get allowedUnsafeSysctls() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_unsafe_sysctls'));
    }
    set allowedUnsafeSysctls(value) {
        this._allowedUnsafeSysctls = value;
    }
    resetAllowedUnsafeSysctls() {
        this._allowedUnsafeSysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedUnsafeSysctlsInput() {
        return this._allowedUnsafeSysctls;
    }
    get containerLogMaxLine() {
        return this.getNumberAttribute('container_log_max_line');
    }
    set containerLogMaxLine(value) {
        this._containerLogMaxLine = value;
    }
    resetContainerLogMaxLine() {
        this._containerLogMaxLine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxLineInput() {
        return this._containerLogMaxLine;
    }
    get containerLogMaxSizeMb() {
        return this.getNumberAttribute('container_log_max_size_mb');
    }
    set containerLogMaxSizeMb(value) {
        this._containerLogMaxSizeMb = value;
    }
    resetContainerLogMaxSizeMb() {
        this._containerLogMaxSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxSizeMbInput() {
        return this._containerLogMaxSizeMb;
    }
    get cpuCfsQuotaEnabled() {
        return this.getBooleanAttribute('cpu_cfs_quota_enabled');
    }
    set cpuCfsQuotaEnabled(value) {
        this._cpuCfsQuotaEnabled = value;
    }
    resetCpuCfsQuotaEnabled() {
        this._cpuCfsQuotaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaEnabledInput() {
        return this._cpuCfsQuotaEnabled;
    }
    get cpuCfsQuotaPeriod() {
        return this.getStringAttribute('cpu_cfs_quota_period');
    }
    set cpuCfsQuotaPeriod(value) {
        this._cpuCfsQuotaPeriod = value;
    }
    resetCpuCfsQuotaPeriod() {
        this._cpuCfsQuotaPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaPeriodInput() {
        return this._cpuCfsQuotaPeriod;
    }
    get cpuManagerPolicy() {
        return this.getStringAttribute('cpu_manager_policy');
    }
    set cpuManagerPolicy(value) {
        this._cpuManagerPolicy = value;
    }
    resetCpuManagerPolicy() {
        this._cpuManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuManagerPolicyInput() {
        return this._cpuManagerPolicy;
    }
    get imageGcHighThreshold() {
        return this.getNumberAttribute('image_gc_high_threshold');
    }
    set imageGcHighThreshold(value) {
        this._imageGcHighThreshold = value;
    }
    resetImageGcHighThreshold() {
        this._imageGcHighThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcHighThresholdInput() {
        return this._imageGcHighThreshold;
    }
    get imageGcLowThreshold() {
        return this.getNumberAttribute('image_gc_low_threshold');
    }
    set imageGcLowThreshold(value) {
        this._imageGcLowThreshold = value;
    }
    resetImageGcLowThreshold() {
        this._imageGcLowThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcLowThresholdInput() {
        return this._imageGcLowThreshold;
    }
    get podMaxPid() {
        return this.getNumberAttribute('pod_max_pid');
    }
    set podMaxPid(value) {
        this._podMaxPid = value;
    }
    resetPodMaxPid() {
        this._podMaxPid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podMaxPidInput() {
        return this._podMaxPid;
    }
    get topologyManagerPolicy() {
        return this.getStringAttribute('topology_manager_policy');
    }
    set topologyManagerPolicy(value) {
        this._topologyManagerPolicy = value;
    }
    resetTopologyManagerPolicy() {
        this._topologyManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topologyManagerPolicyInput() {
        return this._topologyManagerPolicy;
    }
}
exports.KubernetesClusterNodePoolKubeletConfigOutputReference = KubernetesClusterNodePoolKubeletConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolKubeletConfigOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolKubeletConfigOutputReference", version: "0.5.59" };
function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fs_aio_max_nr: cdktf.numberToTerraform(struct.fsAioMaxNr),
        fs_file_max: cdktf.numberToTerraform(struct.fsFileMax),
        fs_inotify_max_user_watches: cdktf.numberToTerraform(struct.fsInotifyMaxUserWatches),
        fs_nr_open: cdktf.numberToTerraform(struct.fsNrOpen),
        kernel_threads_max: cdktf.numberToTerraform(struct.kernelThreadsMax),
        net_core_netdev_max_backlog: cdktf.numberToTerraform(struct.netCoreNetdevMaxBacklog),
        net_core_optmem_max: cdktf.numberToTerraform(struct.netCoreOptmemMax),
        net_core_rmem_default: cdktf.numberToTerraform(struct.netCoreRmemDefault),
        net_core_rmem_max: cdktf.numberToTerraform(struct.netCoreRmemMax),
        net_core_somaxconn: cdktf.numberToTerraform(struct.netCoreSomaxconn),
        net_core_wmem_default: cdktf.numberToTerraform(struct.netCoreWmemDefault),
        net_core_wmem_max: cdktf.numberToTerraform(struct.netCoreWmemMax),
        net_ipv4_ip_local_port_range_max: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMax),
        net_ipv4_ip_local_port_range_min: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMin),
        net_ipv4_neigh_default_gc_thresh1: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh1),
        net_ipv4_neigh_default_gc_thresh2: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh2),
        net_ipv4_neigh_default_gc_thresh3: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh3),
        net_ipv4_tcp_fin_timeout: cdktf.numberToTerraform(struct.netIpv4TcpFinTimeout),
        net_ipv4_tcp_keepalive_intvl: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveIntvl),
        net_ipv4_tcp_keepalive_probes: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveProbes),
        net_ipv4_tcp_keepalive_time: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveTime),
        net_ipv4_tcp_max_syn_backlog: cdktf.numberToTerraform(struct.netIpv4TcpMaxSynBacklog),
        net_ipv4_tcp_max_tw_buckets: cdktf.numberToTerraform(struct.netIpv4TcpMaxTwBuckets),
        net_ipv4_tcp_tw_reuse: cdktf.booleanToTerraform(struct.netIpv4TcpTwReuse),
        net_netfilter_nf_conntrack_buckets: cdktf.numberToTerraform(struct.netNetfilterNfConntrackBuckets),
        net_netfilter_nf_conntrack_max: cdktf.numberToTerraform(struct.netNetfilterNfConntrackMax),
        vm_max_map_count: cdktf.numberToTerraform(struct.vmMaxMapCount),
        vm_swappiness: cdktf.numberToTerraform(struct.vmSwappiness),
        vm_vfs_cache_pressure: cdktf.numberToTerraform(struct.vmVfsCachePressure),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._fsAioMaxNr !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsAioMaxNr = this._fsAioMaxNr;
        }
        if (this._fsFileMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsFileMax = this._fsFileMax;
        }
        if (this._fsInotifyMaxUserWatches !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsInotifyMaxUserWatches = this._fsInotifyMaxUserWatches;
        }
        if (this._fsNrOpen !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsNrOpen = this._fsNrOpen;
        }
        if (this._kernelThreadsMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.kernelThreadsMax = this._kernelThreadsMax;
        }
        if (this._netCoreNetdevMaxBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreNetdevMaxBacklog = this._netCoreNetdevMaxBacklog;
        }
        if (this._netCoreOptmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreOptmemMax = this._netCoreOptmemMax;
        }
        if (this._netCoreRmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemDefault = this._netCoreRmemDefault;
        }
        if (this._netCoreRmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemMax = this._netCoreRmemMax;
        }
        if (this._netCoreSomaxconn !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreSomaxconn = this._netCoreSomaxconn;
        }
        if (this._netCoreWmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemDefault = this._netCoreWmemDefault;
        }
        if (this._netCoreWmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemMax = this._netCoreWmemMax;
        }
        if (this._netIpv4IpLocalPortRangeMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMax = this._netIpv4IpLocalPortRangeMax;
        }
        if (this._netIpv4IpLocalPortRangeMin !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMin = this._netIpv4IpLocalPortRangeMin;
        }
        if (this._netIpv4NeighDefaultGcThresh1 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh1 = this._netIpv4NeighDefaultGcThresh1;
        }
        if (this._netIpv4NeighDefaultGcThresh2 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh2 = this._netIpv4NeighDefaultGcThresh2;
        }
        if (this._netIpv4NeighDefaultGcThresh3 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh3 = this._netIpv4NeighDefaultGcThresh3;
        }
        if (this._netIpv4TcpFinTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpFinTimeout = this._netIpv4TcpFinTimeout;
        }
        if (this._netIpv4TcpKeepaliveIntvl !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveIntvl = this._netIpv4TcpKeepaliveIntvl;
        }
        if (this._netIpv4TcpKeepaliveProbes !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveProbes = this._netIpv4TcpKeepaliveProbes;
        }
        if (this._netIpv4TcpKeepaliveTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveTime = this._netIpv4TcpKeepaliveTime;
        }
        if (this._netIpv4TcpMaxSynBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxSynBacklog = this._netIpv4TcpMaxSynBacklog;
        }
        if (this._netIpv4TcpMaxTwBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxTwBuckets = this._netIpv4TcpMaxTwBuckets;
        }
        if (this._netIpv4TcpTwReuse !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpTwReuse = this._netIpv4TcpTwReuse;
        }
        if (this._netNetfilterNfConntrackBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackBuckets = this._netNetfilterNfConntrackBuckets;
        }
        if (this._netNetfilterNfConntrackMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackMax = this._netNetfilterNfConntrackMax;
        }
        if (this._vmMaxMapCount !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmMaxMapCount = this._vmMaxMapCount;
        }
        if (this._vmSwappiness !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmSwappiness = this._vmSwappiness;
        }
        if (this._vmVfsCachePressure !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmVfsCachePressure = this._vmVfsCachePressure;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._fsAioMaxNr = undefined;
            this._fsFileMax = undefined;
            this._fsInotifyMaxUserWatches = undefined;
            this._fsNrOpen = undefined;
            this._kernelThreadsMax = undefined;
            this._netCoreNetdevMaxBacklog = undefined;
            this._netCoreOptmemMax = undefined;
            this._netCoreRmemDefault = undefined;
            this._netCoreRmemMax = undefined;
            this._netCoreSomaxconn = undefined;
            this._netCoreWmemDefault = undefined;
            this._netCoreWmemMax = undefined;
            this._netIpv4IpLocalPortRangeMax = undefined;
            this._netIpv4IpLocalPortRangeMin = undefined;
            this._netIpv4NeighDefaultGcThresh1 = undefined;
            this._netIpv4NeighDefaultGcThresh2 = undefined;
            this._netIpv4NeighDefaultGcThresh3 = undefined;
            this._netIpv4TcpFinTimeout = undefined;
            this._netIpv4TcpKeepaliveIntvl = undefined;
            this._netIpv4TcpKeepaliveProbes = undefined;
            this._netIpv4TcpKeepaliveTime = undefined;
            this._netIpv4TcpMaxSynBacklog = undefined;
            this._netIpv4TcpMaxTwBuckets = undefined;
            this._netIpv4TcpTwReuse = undefined;
            this._netNetfilterNfConntrackBuckets = undefined;
            this._netNetfilterNfConntrackMax = undefined;
            this._vmMaxMapCount = undefined;
            this._vmSwappiness = undefined;
            this._vmVfsCachePressure = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._fsAioMaxNr = value.fsAioMaxNr;
            this._fsFileMax = value.fsFileMax;
            this._fsInotifyMaxUserWatches = value.fsInotifyMaxUserWatches;
            this._fsNrOpen = value.fsNrOpen;
            this._kernelThreadsMax = value.kernelThreadsMax;
            this._netCoreNetdevMaxBacklog = value.netCoreNetdevMaxBacklog;
            this._netCoreOptmemMax = value.netCoreOptmemMax;
            this._netCoreRmemDefault = value.netCoreRmemDefault;
            this._netCoreRmemMax = value.netCoreRmemMax;
            this._netCoreSomaxconn = value.netCoreSomaxconn;
            this._netCoreWmemDefault = value.netCoreWmemDefault;
            this._netCoreWmemMax = value.netCoreWmemMax;
            this._netIpv4IpLocalPortRangeMax = value.netIpv4IpLocalPortRangeMax;
            this._netIpv4IpLocalPortRangeMin = value.netIpv4IpLocalPortRangeMin;
            this._netIpv4NeighDefaultGcThresh1 = value.netIpv4NeighDefaultGcThresh1;
            this._netIpv4NeighDefaultGcThresh2 = value.netIpv4NeighDefaultGcThresh2;
            this._netIpv4NeighDefaultGcThresh3 = value.netIpv4NeighDefaultGcThresh3;
            this._netIpv4TcpFinTimeout = value.netIpv4TcpFinTimeout;
            this._netIpv4TcpKeepaliveIntvl = value.netIpv4TcpKeepaliveIntvl;
            this._netIpv4TcpKeepaliveProbes = value.netIpv4TcpKeepaliveProbes;
            this._netIpv4TcpKeepaliveTime = value.netIpv4TcpKeepaliveTime;
            this._netIpv4TcpMaxSynBacklog = value.netIpv4TcpMaxSynBacklog;
            this._netIpv4TcpMaxTwBuckets = value.netIpv4TcpMaxTwBuckets;
            this._netIpv4TcpTwReuse = value.netIpv4TcpTwReuse;
            this._netNetfilterNfConntrackBuckets = value.netNetfilterNfConntrackBuckets;
            this._netNetfilterNfConntrackMax = value.netNetfilterNfConntrackMax;
            this._vmMaxMapCount = value.vmMaxMapCount;
            this._vmSwappiness = value.vmSwappiness;
            this._vmVfsCachePressure = value.vmVfsCachePressure;
        }
    }
    get fsAioMaxNr() {
        return this.getNumberAttribute('fs_aio_max_nr');
    }
    set fsAioMaxNr(value) {
        this._fsAioMaxNr = value;
    }
    resetFsAioMaxNr() {
        this._fsAioMaxNr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsAioMaxNrInput() {
        return this._fsAioMaxNr;
    }
    get fsFileMax() {
        return this.getNumberAttribute('fs_file_max');
    }
    set fsFileMax(value) {
        this._fsFileMax = value;
    }
    resetFsFileMax() {
        this._fsFileMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsFileMaxInput() {
        return this._fsFileMax;
    }
    get fsInotifyMaxUserWatches() {
        return this.getNumberAttribute('fs_inotify_max_user_watches');
    }
    set fsInotifyMaxUserWatches(value) {
        this._fsInotifyMaxUserWatches = value;
    }
    resetFsInotifyMaxUserWatches() {
        this._fsInotifyMaxUserWatches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsInotifyMaxUserWatchesInput() {
        return this._fsInotifyMaxUserWatches;
    }
    get fsNrOpen() {
        return this.getNumberAttribute('fs_nr_open');
    }
    set fsNrOpen(value) {
        this._fsNrOpen = value;
    }
    resetFsNrOpen() {
        this._fsNrOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsNrOpenInput() {
        return this._fsNrOpen;
    }
    get kernelThreadsMax() {
        return this.getNumberAttribute('kernel_threads_max');
    }
    set kernelThreadsMax(value) {
        this._kernelThreadsMax = value;
    }
    resetKernelThreadsMax() {
        this._kernelThreadsMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kernelThreadsMaxInput() {
        return this._kernelThreadsMax;
    }
    get netCoreNetdevMaxBacklog() {
        return this.getNumberAttribute('net_core_netdev_max_backlog');
    }
    set netCoreNetdevMaxBacklog(value) {
        this._netCoreNetdevMaxBacklog = value;
    }
    resetNetCoreNetdevMaxBacklog() {
        this._netCoreNetdevMaxBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreNetdevMaxBacklogInput() {
        return this._netCoreNetdevMaxBacklog;
    }
    get netCoreOptmemMax() {
        return this.getNumberAttribute('net_core_optmem_max');
    }
    set netCoreOptmemMax(value) {
        this._netCoreOptmemMax = value;
    }
    resetNetCoreOptmemMax() {
        this._netCoreOptmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreOptmemMaxInput() {
        return this._netCoreOptmemMax;
    }
    get netCoreRmemDefault() {
        return this.getNumberAttribute('net_core_rmem_default');
    }
    set netCoreRmemDefault(value) {
        this._netCoreRmemDefault = value;
    }
    resetNetCoreRmemDefault() {
        this._netCoreRmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemDefaultInput() {
        return this._netCoreRmemDefault;
    }
    get netCoreRmemMax() {
        return this.getNumberAttribute('net_core_rmem_max');
    }
    set netCoreRmemMax(value) {
        this._netCoreRmemMax = value;
    }
    resetNetCoreRmemMax() {
        this._netCoreRmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemMaxInput() {
        return this._netCoreRmemMax;
    }
    get netCoreSomaxconn() {
        return this.getNumberAttribute('net_core_somaxconn');
    }
    set netCoreSomaxconn(value) {
        this._netCoreSomaxconn = value;
    }
    resetNetCoreSomaxconn() {
        this._netCoreSomaxconn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreSomaxconnInput() {
        return this._netCoreSomaxconn;
    }
    get netCoreWmemDefault() {
        return this.getNumberAttribute('net_core_wmem_default');
    }
    set netCoreWmemDefault(value) {
        this._netCoreWmemDefault = value;
    }
    resetNetCoreWmemDefault() {
        this._netCoreWmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemDefaultInput() {
        return this._netCoreWmemDefault;
    }
    get netCoreWmemMax() {
        return this.getNumberAttribute('net_core_wmem_max');
    }
    set netCoreWmemMax(value) {
        this._netCoreWmemMax = value;
    }
    resetNetCoreWmemMax() {
        this._netCoreWmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemMaxInput() {
        return this._netCoreWmemMax;
    }
    get netIpv4IpLocalPortRangeMax() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_max');
    }
    set netIpv4IpLocalPortRangeMax(value) {
        this._netIpv4IpLocalPortRangeMax = value;
    }
    resetNetIpv4IpLocalPortRangeMax() {
        this._netIpv4IpLocalPortRangeMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMaxInput() {
        return this._netIpv4IpLocalPortRangeMax;
    }
    get netIpv4IpLocalPortRangeMin() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_min');
    }
    set netIpv4IpLocalPortRangeMin(value) {
        this._netIpv4IpLocalPortRangeMin = value;
    }
    resetNetIpv4IpLocalPortRangeMin() {
        this._netIpv4IpLocalPortRangeMin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMinInput() {
        return this._netIpv4IpLocalPortRangeMin;
    }
    get netIpv4NeighDefaultGcThresh1() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh1');
    }
    set netIpv4NeighDefaultGcThresh1(value) {
        this._netIpv4NeighDefaultGcThresh1 = value;
    }
    resetNetIpv4NeighDefaultGcThresh1() {
        this._netIpv4NeighDefaultGcThresh1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh1Input() {
        return this._netIpv4NeighDefaultGcThresh1;
    }
    get netIpv4NeighDefaultGcThresh2() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh2');
    }
    set netIpv4NeighDefaultGcThresh2(value) {
        this._netIpv4NeighDefaultGcThresh2 = value;
    }
    resetNetIpv4NeighDefaultGcThresh2() {
        this._netIpv4NeighDefaultGcThresh2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh2Input() {
        return this._netIpv4NeighDefaultGcThresh2;
    }
    get netIpv4NeighDefaultGcThresh3() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh3');
    }
    set netIpv4NeighDefaultGcThresh3(value) {
        this._netIpv4NeighDefaultGcThresh3 = value;
    }
    resetNetIpv4NeighDefaultGcThresh3() {
        this._netIpv4NeighDefaultGcThresh3 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh3Input() {
        return this._netIpv4NeighDefaultGcThresh3;
    }
    get netIpv4TcpFinTimeout() {
        return this.getNumberAttribute('net_ipv4_tcp_fin_timeout');
    }
    set netIpv4TcpFinTimeout(value) {
        this._netIpv4TcpFinTimeout = value;
    }
    resetNetIpv4TcpFinTimeout() {
        this._netIpv4TcpFinTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpFinTimeoutInput() {
        return this._netIpv4TcpFinTimeout;
    }
    get netIpv4TcpKeepaliveIntvl() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_intvl');
    }
    set netIpv4TcpKeepaliveIntvl(value) {
        this._netIpv4TcpKeepaliveIntvl = value;
    }
    resetNetIpv4TcpKeepaliveIntvl() {
        this._netIpv4TcpKeepaliveIntvl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveIntvlInput() {
        return this._netIpv4TcpKeepaliveIntvl;
    }
    get netIpv4TcpKeepaliveProbes() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_probes');
    }
    set netIpv4TcpKeepaliveProbes(value) {
        this._netIpv4TcpKeepaliveProbes = value;
    }
    resetNetIpv4TcpKeepaliveProbes() {
        this._netIpv4TcpKeepaliveProbes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveProbesInput() {
        return this._netIpv4TcpKeepaliveProbes;
    }
    get netIpv4TcpKeepaliveTime() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_time');
    }
    set netIpv4TcpKeepaliveTime(value) {
        this._netIpv4TcpKeepaliveTime = value;
    }
    resetNetIpv4TcpKeepaliveTime() {
        this._netIpv4TcpKeepaliveTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveTimeInput() {
        return this._netIpv4TcpKeepaliveTime;
    }
    get netIpv4TcpMaxSynBacklog() {
        return this.getNumberAttribute('net_ipv4_tcp_max_syn_backlog');
    }
    set netIpv4TcpMaxSynBacklog(value) {
        this._netIpv4TcpMaxSynBacklog = value;
    }
    resetNetIpv4TcpMaxSynBacklog() {
        this._netIpv4TcpMaxSynBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxSynBacklogInput() {
        return this._netIpv4TcpMaxSynBacklog;
    }
    get netIpv4TcpMaxTwBuckets() {
        return this.getNumberAttribute('net_ipv4_tcp_max_tw_buckets');
    }
    set netIpv4TcpMaxTwBuckets(value) {
        this._netIpv4TcpMaxTwBuckets = value;
    }
    resetNetIpv4TcpMaxTwBuckets() {
        this._netIpv4TcpMaxTwBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxTwBucketsInput() {
        return this._netIpv4TcpMaxTwBuckets;
    }
    get netIpv4TcpTwReuse() {
        return this.getBooleanAttribute('net_ipv4_tcp_tw_reuse');
    }
    set netIpv4TcpTwReuse(value) {
        this._netIpv4TcpTwReuse = value;
    }
    resetNetIpv4TcpTwReuse() {
        this._netIpv4TcpTwReuse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpTwReuseInput() {
        return this._netIpv4TcpTwReuse;
    }
    get netNetfilterNfConntrackBuckets() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_buckets');
    }
    set netNetfilterNfConntrackBuckets(value) {
        this._netNetfilterNfConntrackBuckets = value;
    }
    resetNetNetfilterNfConntrackBuckets() {
        this._netNetfilterNfConntrackBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackBucketsInput() {
        return this._netNetfilterNfConntrackBuckets;
    }
    get netNetfilterNfConntrackMax() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_max');
    }
    set netNetfilterNfConntrackMax(value) {
        this._netNetfilterNfConntrackMax = value;
    }
    resetNetNetfilterNfConntrackMax() {
        this._netNetfilterNfConntrackMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackMaxInput() {
        return this._netNetfilterNfConntrackMax;
    }
    get vmMaxMapCount() {
        return this.getNumberAttribute('vm_max_map_count');
    }
    set vmMaxMapCount(value) {
        this._vmMaxMapCount = value;
    }
    resetVmMaxMapCount() {
        this._vmMaxMapCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmMaxMapCountInput() {
        return this._vmMaxMapCount;
    }
    get vmSwappiness() {
        return this.getNumberAttribute('vm_swappiness');
    }
    set vmSwappiness(value) {
        this._vmSwappiness = value;
    }
    resetVmSwappiness() {
        this._vmSwappiness = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmSwappinessInput() {
        return this._vmSwappiness;
    }
    get vmVfsCachePressure() {
        return this.getNumberAttribute('vm_vfs_cache_pressure');
    }
    set vmVfsCachePressure(value) {
        this._vmVfsCachePressure = value;
    }
    resetVmVfsCachePressure() {
        this._vmVfsCachePressure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmVfsCachePressureInput() {
        return this._vmVfsCachePressure;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference", version: "0.5.59" };
function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        swap_file_size_mb: cdktf.numberToTerraform(struct.swapFileSizeMb),
        transparent_huge_page_defrag: cdktf.stringToTerraform(struct.transparentHugePageDefrag),
        transparent_huge_page_enabled: cdktf.stringToTerraform(struct.transparentHugePageEnabled),
        sysctl_config: kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct.sysctlConfig),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // sysctl_config - computed: false, optional: true, required: false
        this._sysctlConfig = new KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference(this, "sysctl_config", true);
    }
    get internalValue() {
        var _g, _h;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._swapFileSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.swapFileSizeMb = this._swapFileSizeMb;
        }
        if (this._transparentHugePageDefrag !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageDefrag = this._transparentHugePageDefrag;
        }
        if (this._transparentHugePageEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageEnabled = this._transparentHugePageEnabled;
        }
        if (((_g = this._sysctlConfig) === null || _g === void 0 ? void 0 : _g.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.sysctlConfig = (_h = this._sysctlConfig) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._swapFileSizeMb = undefined;
            this._transparentHugePageDefrag = undefined;
            this._transparentHugePageEnabled = undefined;
            this._sysctlConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._swapFileSizeMb = value.swapFileSizeMb;
            this._transparentHugePageDefrag = value.transparentHugePageDefrag;
            this._transparentHugePageEnabled = value.transparentHugePageEnabled;
            this._sysctlConfig.internalValue = value.sysctlConfig;
        }
    }
    get swapFileSizeMb() {
        return this.getNumberAttribute('swap_file_size_mb');
    }
    set swapFileSizeMb(value) {
        this._swapFileSizeMb = value;
    }
    resetSwapFileSizeMb() {
        this._swapFileSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapFileSizeMbInput() {
        return this._swapFileSizeMb;
    }
    get transparentHugePageDefrag() {
        return this.getStringAttribute('transparent_huge_page_defrag');
    }
    set transparentHugePageDefrag(value) {
        this._transparentHugePageDefrag = value;
    }
    resetTransparentHugePageDefrag() {
        this._transparentHugePageDefrag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageDefragInput() {
        return this._transparentHugePageDefrag;
    }
    get transparentHugePageEnabled() {
        return this.getStringAttribute('transparent_huge_page_enabled');
    }
    set transparentHugePageEnabled(value) {
        this._transparentHugePageEnabled = value;
    }
    resetTransparentHugePageEnabled() {
        this._transparentHugePageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageEnabledInput() {
        return this._transparentHugePageEnabled;
    }
    get sysctlConfig() {
        return this._sysctlConfig;
    }
    putSysctlConfig(value) {
        this._sysctlConfig.internalValue = value;
    }
    resetSysctlConfig() {
        this._sysctlConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sysctlConfigInput() {
        return this._sysctlConfig.internalValue;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigOutputReference", version: "0.5.59" };
function kubernetesClusterNodePoolTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.kubernetesClusterNodePoolTimeoutsToTerraform = kubernetesClusterNodePoolTimeoutsToTerraform;
class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.KubernetesClusterNodePoolTimeoutsOutputReference = KubernetesClusterNodePoolTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolTimeoutsOutputReference", version: "0.5.59" };
function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_surge: cdktf.stringToTerraform(struct.maxSurge),
    };
}
exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = kubernetesClusterNodePoolUpgradeSettingsToTerraform;
class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxSurge !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxSurge = this._maxSurge;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxSurge = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxSurge = value.maxSurge;
        }
    }
    get maxSurge() {
        return this.getStringAttribute('max_surge');
    }
    set maxSurge(value) {
        this._maxSurge = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxSurgeInput() {
        return this._maxSurge;
    }
}
exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = KubernetesClusterNodePoolUpgradeSettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolUpgradeSettingsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolUpgradeSettingsOutputReference", version: "0.5.59" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
class KubernetesClusterNodePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterNodePoolConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_kubernetes_cluster_node_pool',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // kubelet_config - computed: false, optional: true, required: false
        this._kubeletConfig = new KubernetesClusterNodePoolKubeletConfigOutputReference(this, "kubelet_config", true);
        // linux_os_config - computed: false, optional: true, required: false
        this._linuxOsConfig = new KubernetesClusterNodePoolLinuxOsConfigOutputReference(this, "linux_os_config", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new KubernetesClusterNodePoolTimeoutsOutputReference(this, "timeouts", true);
        // upgrade_settings - computed: false, optional: true, required: false
        this._upgradeSettings = new KubernetesClusterNodePoolUpgradeSettingsOutputReference(this, "upgrade_settings", true);
        this._availabilityZones = config.availabilityZones;
        this._enableAutoScaling = config.enableAutoScaling;
        this._enableHostEncryption = config.enableHostEncryption;
        this._enableNodePublicIp = config.enableNodePublicIp;
        this._evictionPolicy = config.evictionPolicy;
        this._fipsEnabled = config.fipsEnabled;
        this._kubeletDiskType = config.kubeletDiskType;
        this._kubernetesClusterId = config.kubernetesClusterId;
        this._maxCount = config.maxCount;
        this._maxPods = config.maxPods;
        this._minCount = config.minCount;
        this._mode = config.mode;
        this._name = config.name;
        this._nodeCount = config.nodeCount;
        this._nodeLabels = config.nodeLabels;
        this._nodePublicIpPrefixId = config.nodePublicIpPrefixId;
        this._nodeTaints = config.nodeTaints;
        this._orchestratorVersion = config.orchestratorVersion;
        this._osDiskSizeGb = config.osDiskSizeGb;
        this._osDiskType = config.osDiskType;
        this._osSku = config.osSku;
        this._osType = config.osType;
        this._podSubnetId = config.podSubnetId;
        this._priority = config.priority;
        this._proximityPlacementGroupId = config.proximityPlacementGroupId;
        this._scaleDownMode = config.scaleDownMode;
        this._spotMaxPrice = config.spotMaxPrice;
        this._tags = config.tags;
        this._ultraSsdEnabled = config.ultraSsdEnabled;
        this._vmSize = config.vmSize;
        this._vnetSubnetId = config.vnetSubnetId;
        this._workloadRuntime = config.workloadRuntime;
        this._kubeletConfig.internalValue = config.kubeletConfig;
        this._linuxOsConfig.internalValue = config.linuxOsConfig;
        this._timeouts.internalValue = config.timeouts;
        this._upgradeSettings.internalValue = config.upgradeSettings;
    }
    get availabilityZones() {
        return this.getListAttribute('availability_zones');
    }
    set availabilityZones(value) {
        this._availabilityZones = value;
    }
    resetAvailabilityZones() {
        this._availabilityZones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availabilityZonesInput() {
        return this._availabilityZones;
    }
    get enableAutoScaling() {
        return this.getBooleanAttribute('enable_auto_scaling');
    }
    set enableAutoScaling(value) {
        this._enableAutoScaling = value;
    }
    resetEnableAutoScaling() {
        this._enableAutoScaling = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutoScalingInput() {
        return this._enableAutoScaling;
    }
    get enableHostEncryption() {
        return this.getBooleanAttribute('enable_host_encryption');
    }
    set enableHostEncryption(value) {
        this._enableHostEncryption = value;
    }
    resetEnableHostEncryption() {
        this._enableHostEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHostEncryptionInput() {
        return this._enableHostEncryption;
    }
    get enableNodePublicIp() {
        return this.getBooleanAttribute('enable_node_public_ip');
    }
    set enableNodePublicIp(value) {
        this._enableNodePublicIp = value;
    }
    resetEnableNodePublicIp() {
        this._enableNodePublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableNodePublicIpInput() {
        return this._enableNodePublicIp;
    }
    get evictionPolicy() {
        return this.getStringAttribute('eviction_policy');
    }
    set evictionPolicy(value) {
        this._evictionPolicy = value;
    }
    resetEvictionPolicy() {
        this._evictionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evictionPolicyInput() {
        return this._evictionPolicy;
    }
    get fipsEnabled() {
        return this.getBooleanAttribute('fips_enabled');
    }
    set fipsEnabled(value) {
        this._fipsEnabled = value;
    }
    resetFipsEnabled() {
        this._fipsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fipsEnabledInput() {
        return this._fipsEnabled;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get kubeletDiskType() {
        return this.getStringAttribute('kubelet_disk_type');
    }
    set kubeletDiskType(value) {
        this._kubeletDiskType = value;
    }
    resetKubeletDiskType() {
        this._kubeletDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletDiskTypeInput() {
        return this._kubeletDiskType;
    }
    get kubernetesClusterId() {
        return this.getStringAttribute('kubernetes_cluster_id');
    }
    set kubernetesClusterId(value) {
        this._kubernetesClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesClusterIdInput() {
        return this._kubernetesClusterId;
    }
    get maxCount() {
        return this.getNumberAttribute('max_count');
    }
    set maxCount(value) {
        this._maxCount = value;
    }
    resetMaxCount() {
        this._maxCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxCountInput() {
        return this._maxCount;
    }
    get maxPods() {
        return this.getNumberAttribute('max_pods');
    }
    set maxPods(value) {
        this._maxPods = value;
    }
    resetMaxPods() {
        this._maxPods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPodsInput() {
        return this._maxPods;
    }
    get minCount() {
        return this.getNumberAttribute('min_count');
    }
    set minCount(value) {
        this._minCount = value;
    }
    resetMinCount() {
        this._minCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minCountInput() {
        return this._minCount;
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeCount() {
        return this.getNumberAttribute('node_count');
    }
    set nodeCount(value) {
        this._nodeCount = value;
    }
    resetNodeCount() {
        this._nodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeCountInput() {
        return this._nodeCount;
    }
    get nodeLabels() {
        return this.getStringMapAttribute('node_labels');
    }
    set nodeLabels(value) {
        this._nodeLabels = value;
    }
    resetNodeLabels() {
        this._nodeLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeLabelsInput() {
        return this._nodeLabels;
    }
    get nodePublicIpPrefixId() {
        return this.getStringAttribute('node_public_ip_prefix_id');
    }
    set nodePublicIpPrefixId(value) {
        this._nodePublicIpPrefixId = value;
    }
    resetNodePublicIpPrefixId() {
        this._nodePublicIpPrefixId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePublicIpPrefixIdInput() {
        return this._nodePublicIpPrefixId;
    }
    get nodeTaints() {
        return this.getListAttribute('node_taints');
    }
    set nodeTaints(value) {
        this._nodeTaints = value;
    }
    resetNodeTaints() {
        this._nodeTaints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeTaintsInput() {
        return this._nodeTaints;
    }
    get orchestratorVersion() {
        return this.getStringAttribute('orchestrator_version');
    }
    set orchestratorVersion(value) {
        this._orchestratorVersion = value;
    }
    resetOrchestratorVersion() {
        this._orchestratorVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orchestratorVersionInput() {
        return this._orchestratorVersion;
    }
    get osDiskSizeGb() {
        return this.getNumberAttribute('os_disk_size_gb');
    }
    set osDiskSizeGb(value) {
        this._osDiskSizeGb = value;
    }
    resetOsDiskSizeGb() {
        this._osDiskSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskSizeGbInput() {
        return this._osDiskSizeGb;
    }
    get osDiskType() {
        return this.getStringAttribute('os_disk_type');
    }
    set osDiskType(value) {
        this._osDiskType = value;
    }
    resetOsDiskType() {
        this._osDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskTypeInput() {
        return this._osDiskType;
    }
    get osSku() {
        return this.getStringAttribute('os_sku');
    }
    set osSku(value) {
        this._osSku = value;
    }
    resetOsSku() {
        this._osSku = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osSkuInput() {
        return this._osSku;
    }
    get osType() {
        return this.getStringAttribute('os_type');
    }
    set osType(value) {
        this._osType = value;
    }
    resetOsType() {
        this._osType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osTypeInput() {
        return this._osType;
    }
    get podSubnetId() {
        return this.getStringAttribute('pod_subnet_id');
    }
    set podSubnetId(value) {
        this._podSubnetId = value;
    }
    resetPodSubnetId() {
        this._podSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podSubnetIdInput() {
        return this._podSubnetId;
    }
    get priority() {
        return this.getStringAttribute('priority');
    }
    set priority(value) {
        this._priority = value;
    }
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get priorityInput() {
        return this._priority;
    }
    get proximityPlacementGroupId() {
        return this.getStringAttribute('proximity_placement_group_id');
    }
    set proximityPlacementGroupId(value) {
        this._proximityPlacementGroupId = value;
    }
    resetProximityPlacementGroupId() {
        this._proximityPlacementGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proximityPlacementGroupIdInput() {
        return this._proximityPlacementGroupId;
    }
    get scaleDownMode() {
        return this.getStringAttribute('scale_down_mode');
    }
    set scaleDownMode(value) {
        this._scaleDownMode = value;
    }
    resetScaleDownMode() {
        this._scaleDownMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scaleDownModeInput() {
        return this._scaleDownMode;
    }
    get spotMaxPrice() {
        return this.getNumberAttribute('spot_max_price');
    }
    set spotMaxPrice(value) {
        this._spotMaxPrice = value;
    }
    resetSpotMaxPrice() {
        this._spotMaxPrice = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spotMaxPriceInput() {
        return this._spotMaxPrice;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get ultraSsdEnabled() {
        return this.getBooleanAttribute('ultra_ssd_enabled');
    }
    set ultraSsdEnabled(value) {
        this._ultraSsdEnabled = value;
    }
    resetUltraSsdEnabled() {
        this._ultraSsdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ultraSsdEnabledInput() {
        return this._ultraSsdEnabled;
    }
    get vmSize() {
        return this.getStringAttribute('vm_size');
    }
    set vmSize(value) {
        this._vmSize = value;
    }
    // Temporarily expose input value. Use with caution.
    get vmSizeInput() {
        return this._vmSize;
    }
    get vnetSubnetId() {
        return this.getStringAttribute('vnet_subnet_id');
    }
    set vnetSubnetId(value) {
        this._vnetSubnetId = value;
    }
    resetVnetSubnetId() {
        this._vnetSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vnetSubnetIdInput() {
        return this._vnetSubnetId;
    }
    get workloadRuntime() {
        return this.getStringAttribute('workload_runtime');
    }
    set workloadRuntime(value) {
        this._workloadRuntime = value;
    }
    resetWorkloadRuntime() {
        this._workloadRuntime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadRuntimeInput() {
        return this._workloadRuntime;
    }
    get kubeletConfig() {
        return this._kubeletConfig;
    }
    putKubeletConfig(value) {
        this._kubeletConfig.internalValue = value;
    }
    resetKubeletConfig() {
        this._kubeletConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletConfigInput() {
        return this._kubeletConfig.internalValue;
    }
    get linuxOsConfig() {
        return this._linuxOsConfig;
    }
    putLinuxOsConfig(value) {
        this._linuxOsConfig.internalValue = value;
    }
    resetLinuxOsConfig() {
        this._linuxOsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linuxOsConfigInput() {
        return this._linuxOsConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get upgradeSettings() {
        return this._upgradeSettings;
    }
    putUpgradeSettings(value) {
        this._upgradeSettings.internalValue = value;
    }
    resetUpgradeSettings() {
        this._upgradeSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upgradeSettingsInput() {
        return this._upgradeSettings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            availability_zones: cdktf.listMapper(cdktf.stringToTerraform)(this._availabilityZones),
            enable_auto_scaling: cdktf.booleanToTerraform(this._enableAutoScaling),
            enable_host_encryption: cdktf.booleanToTerraform(this._enableHostEncryption),
            enable_node_public_ip: cdktf.booleanToTerraform(this._enableNodePublicIp),
            eviction_policy: cdktf.stringToTerraform(this._evictionPolicy),
            fips_enabled: cdktf.booleanToTerraform(this._fipsEnabled),
            kubelet_disk_type: cdktf.stringToTerraform(this._kubeletDiskType),
            kubernetes_cluster_id: cdktf.stringToTerraform(this._kubernetesClusterId),
            max_count: cdktf.numberToTerraform(this._maxCount),
            max_pods: cdktf.numberToTerraform(this._maxPods),
            min_count: cdktf.numberToTerraform(this._minCount),
            mode: cdktf.stringToTerraform(this._mode),
            name: cdktf.stringToTerraform(this._name),
            node_count: cdktf.numberToTerraform(this._nodeCount),
            node_labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._nodeLabels),
            node_public_ip_prefix_id: cdktf.stringToTerraform(this._nodePublicIpPrefixId),
            node_taints: cdktf.listMapper(cdktf.stringToTerraform)(this._nodeTaints),
            orchestrator_version: cdktf.stringToTerraform(this._orchestratorVersion),
            os_disk_size_gb: cdktf.numberToTerraform(this._osDiskSizeGb),
            os_disk_type: cdktf.stringToTerraform(this._osDiskType),
            os_sku: cdktf.stringToTerraform(this._osSku),
            os_type: cdktf.stringToTerraform(this._osType),
            pod_subnet_id: cdktf.stringToTerraform(this._podSubnetId),
            priority: cdktf.stringToTerraform(this._priority),
            proximity_placement_group_id: cdktf.stringToTerraform(this._proximityPlacementGroupId),
            scale_down_mode: cdktf.stringToTerraform(this._scaleDownMode),
            spot_max_price: cdktf.numberToTerraform(this._spotMaxPrice),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            ultra_ssd_enabled: cdktf.booleanToTerraform(this._ultraSsdEnabled),
            vm_size: cdktf.stringToTerraform(this._vmSize),
            vnet_subnet_id: cdktf.stringToTerraform(this._vnetSubnetId),
            workload_runtime: cdktf.stringToTerraform(this._workloadRuntime),
            kubelet_config: kubernetesClusterNodePoolKubeletConfigToTerraform(this._kubeletConfig.internalValue),
            linux_os_config: kubernetesClusterNodePoolLinuxOsConfigToTerraform(this._linuxOsConfig.internalValue),
            timeouts: kubernetesClusterNodePoolTimeoutsToTerraform(this._timeouts.internalValue),
            upgrade_settings: kubernetesClusterNodePoolUpgradeSettingsToTerraform(this._upgradeSettings.internalValue),
        };
    }
}
exports.KubernetesClusterNodePool = KubernetesClusterNodePool;
_f = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePool[_f] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePool", version: "0.5.59" };
// =================
// STATIC PROPERTIES
// =================
KubernetesClusterNodePool.tfResourceType = "azurerm_kubernetes_cluster_node_pool";
//# sourceMappingURL=data:application/json;base64,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