import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#auto_stop_enabled KustoCluster#auto_stop_enabled}
    */
    readonly autoStopEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#disk_encryption_enabled KustoCluster#disk_encryption_enabled}
    */
    readonly diskEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#double_encryption_enabled KustoCluster#double_encryption_enabled}
    */
    readonly doubleEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#enable_auto_stop KustoCluster#enable_auto_stop}
    */
    readonly enableAutoStop?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#enable_disk_encryption KustoCluster#enable_disk_encryption}
    */
    readonly enableDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#enable_purge KustoCluster#enable_purge}
    */
    readonly enablePurge?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#enable_streaming_ingest KustoCluster#enable_streaming_ingest}
    */
    readonly enableStreamingIngest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#engine KustoCluster#engine}
    */
    readonly engine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#language_extensions KustoCluster#language_extensions}
    */
    readonly languageExtensions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#location KustoCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#name KustoCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#public_network_access_enabled KustoCluster#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#purge_enabled KustoCluster#purge_enabled}
    */
    readonly purgeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#resource_group_name KustoCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#streaming_ingestion_enabled KustoCluster#streaming_ingestion_enabled}
    */
    readonly streamingIngestionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#tags KustoCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#trusted_external_tenants KustoCluster#trusted_external_tenants}
    */
    readonly trustedExternalTenants?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#zones KustoCluster#zones}
    */
    readonly zones?: string[];
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#identity KustoCluster#identity}
    */
    readonly identity?: KustoClusterIdentity;
    /**
    * optimized_auto_scale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#optimized_auto_scale KustoCluster#optimized_auto_scale}
    */
    readonly optimizedAutoScale?: KustoClusterOptimizedAutoScale;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#sku KustoCluster#sku}
    */
    readonly sku: KustoClusterSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#timeouts KustoCluster#timeouts}
    */
    readonly timeouts?: KustoClusterTimeouts;
    /**
    * virtual_network_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#virtual_network_configuration KustoCluster#virtual_network_configuration}
    */
    readonly virtualNetworkConfiguration?: KustoClusterVirtualNetworkConfiguration;
}
export interface KustoClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#identity_ids KustoCluster#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#type KustoCluster#type}
    */
    readonly type: string;
}
export declare function kustoClusterIdentityToTerraform(struct?: KustoClusterIdentityOutputReference | KustoClusterIdentity): any;
export declare class KustoClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoClusterIdentity | undefined;
    set internalValue(value: KustoClusterIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface KustoClusterOptimizedAutoScale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#maximum_instances KustoCluster#maximum_instances}
    */
    readonly maximumInstances: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#minimum_instances KustoCluster#minimum_instances}
    */
    readonly minimumInstances: number;
}
export declare function kustoClusterOptimizedAutoScaleToTerraform(struct?: KustoClusterOptimizedAutoScaleOutputReference | KustoClusterOptimizedAutoScale): any;
export declare class KustoClusterOptimizedAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoClusterOptimizedAutoScale | undefined;
    set internalValue(value: KustoClusterOptimizedAutoScale | undefined);
    private _maximumInstances?;
    get maximumInstances(): number;
    set maximumInstances(value: number);
    get maximumInstancesInput(): number | undefined;
    private _minimumInstances?;
    get minimumInstances(): number;
    set minimumInstances(value: number);
    get minimumInstancesInput(): number | undefined;
}
export interface KustoClusterSku {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#capacity KustoCluster#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#name KustoCluster#name}
    */
    readonly name: string;
}
export declare function kustoClusterSkuToTerraform(struct?: KustoClusterSkuOutputReference | KustoClusterSku): any;
export declare class KustoClusterSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoClusterSku | undefined;
    set internalValue(value: KustoClusterSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface KustoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#create KustoCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#delete KustoCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#read KustoCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#update KustoCluster#update}
    */
    readonly update?: string;
}
export declare function kustoClusterTimeoutsToTerraform(struct?: KustoClusterTimeoutsOutputReference | KustoClusterTimeouts | cdktf.IResolvable): any;
export declare class KustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoClusterTimeouts | undefined;
    set internalValue(value: KustoClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface KustoClusterVirtualNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#data_management_public_ip_id KustoCluster#data_management_public_ip_id}
    */
    readonly dataManagementPublicIpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#engine_public_ip_id KustoCluster#engine_public_ip_id}
    */
    readonly enginePublicIpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster#subnet_id KustoCluster#subnet_id}
    */
    readonly subnetId: string;
}
export declare function kustoClusterVirtualNetworkConfigurationToTerraform(struct?: KustoClusterVirtualNetworkConfigurationOutputReference | KustoClusterVirtualNetworkConfiguration): any;
export declare class KustoClusterVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoClusterVirtualNetworkConfiguration | undefined;
    set internalValue(value: KustoClusterVirtualNetworkConfiguration | undefined);
    private _dataManagementPublicIpId?;
    get dataManagementPublicIpId(): string;
    set dataManagementPublicIpId(value: string);
    get dataManagementPublicIpIdInput(): string | undefined;
    private _enginePublicIpId?;
    get enginePublicIpId(): string;
    set enginePublicIpId(value: string);
    get enginePublicIpIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster azurerm_kusto_cluster}
*/
export declare class KustoCluster extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster azurerm_kusto_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoClusterConfig
    */
    constructor(scope: Construct, id: string, config: KustoClusterConfig);
    private _autoStopEnabled?;
    get autoStopEnabled(): boolean | cdktf.IResolvable;
    set autoStopEnabled(value: boolean | cdktf.IResolvable);
    resetAutoStopEnabled(): void;
    get autoStopEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get dataIngestionUri(): string;
    private _diskEncryptionEnabled?;
    get diskEncryptionEnabled(): boolean | cdktf.IResolvable;
    set diskEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetDiskEncryptionEnabled(): void;
    get diskEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _doubleEncryptionEnabled?;
    get doubleEncryptionEnabled(): boolean | cdktf.IResolvable;
    set doubleEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetDoubleEncryptionEnabled(): void;
    get doubleEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutoStop?;
    get enableAutoStop(): boolean | cdktf.IResolvable;
    set enableAutoStop(value: boolean | cdktf.IResolvable);
    resetEnableAutoStop(): void;
    get enableAutoStopInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDiskEncryption?;
    get enableDiskEncryption(): boolean | cdktf.IResolvable;
    set enableDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableDiskEncryption(): void;
    get enableDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePurge?;
    get enablePurge(): boolean | cdktf.IResolvable;
    set enablePurge(value: boolean | cdktf.IResolvable);
    resetEnablePurge(): void;
    get enablePurgeInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStreamingIngest?;
    get enableStreamingIngest(): boolean | cdktf.IResolvable;
    set enableStreamingIngest(value: boolean | cdktf.IResolvable);
    resetEnableStreamingIngest(): void;
    get enableStreamingIngestInput(): boolean | cdktf.IResolvable | undefined;
    private _engine?;
    get engine(): string;
    set engine(value: string);
    resetEngine(): void;
    get engineInput(): string | undefined;
    get id(): string;
    private _languageExtensions?;
    get languageExtensions(): string[];
    set languageExtensions(value: string[]);
    resetLanguageExtensions(): void;
    get languageExtensionsInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _purgeEnabled?;
    get purgeEnabled(): boolean | cdktf.IResolvable;
    set purgeEnabled(value: boolean | cdktf.IResolvable);
    resetPurgeEnabled(): void;
    get purgeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _streamingIngestionEnabled?;
    get streamingIngestionEnabled(): boolean | cdktf.IResolvable;
    set streamingIngestionEnabled(value: boolean | cdktf.IResolvable);
    resetStreamingIngestionEnabled(): void;
    get streamingIngestionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trustedExternalTenants?;
    get trustedExternalTenants(): string[];
    set trustedExternalTenants(value: string[]);
    resetTrustedExternalTenants(): void;
    get trustedExternalTenantsInput(): string[] | undefined;
    get uri(): string;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _identity;
    get identity(): KustoClusterIdentityOutputReference;
    putIdentity(value: KustoClusterIdentity): void;
    resetIdentity(): void;
    get identityInput(): KustoClusterIdentity | undefined;
    private _optimizedAutoScale;
    get optimizedAutoScale(): KustoClusterOptimizedAutoScaleOutputReference;
    putOptimizedAutoScale(value: KustoClusterOptimizedAutoScale): void;
    resetOptimizedAutoScale(): void;
    get optimizedAutoScaleInput(): KustoClusterOptimizedAutoScale | undefined;
    private _sku;
    get sku(): KustoClusterSkuOutputReference;
    putSku(value: KustoClusterSku): void;
    get skuInput(): KustoClusterSku | undefined;
    private _timeouts;
    get timeouts(): KustoClusterTimeoutsOutputReference;
    putTimeouts(value: KustoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KustoClusterTimeouts | undefined;
    private _virtualNetworkConfiguration;
    get virtualNetworkConfiguration(): KustoClusterVirtualNetworkConfigurationOutputReference;
    putVirtualNetworkConfiguration(value: KustoClusterVirtualNetworkConfiguration): void;
    resetVirtualNetworkConfiguration(): void;
    get virtualNetworkConfigurationInput(): KustoClusterVirtualNetworkConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
