import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogAnalyticsSolutionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#location LogAnalyticsSolution#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#resource_group_name LogAnalyticsSolution#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#solution_name LogAnalyticsSolution#solution_name}
    */
    readonly solutionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#tags LogAnalyticsSolution#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#workspace_name LogAnalyticsSolution#workspace_name}
    */
    readonly workspaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#workspace_resource_id LogAnalyticsSolution#workspace_resource_id}
    */
    readonly workspaceResourceId: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#plan LogAnalyticsSolution#plan}
    */
    readonly plan: LogAnalyticsSolutionPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#timeouts LogAnalyticsSolution#timeouts}
    */
    readonly timeouts?: LogAnalyticsSolutionTimeouts;
}
export interface LogAnalyticsSolutionPlan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#product LogAnalyticsSolution#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#promotion_code LogAnalyticsSolution#promotion_code}
    */
    readonly promotionCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#publisher LogAnalyticsSolution#publisher}
    */
    readonly publisher: string;
}
export declare function logAnalyticsSolutionPlanToTerraform(struct?: LogAnalyticsSolutionPlanOutputReference | LogAnalyticsSolutionPlan): any;
export declare class LogAnalyticsSolutionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogAnalyticsSolutionPlan | undefined;
    set internalValue(value: LogAnalyticsSolutionPlan | undefined);
    get name(): string;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _promotionCode?;
    get promotionCode(): string;
    set promotionCode(value: string);
    resetPromotionCode(): void;
    get promotionCodeInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface LogAnalyticsSolutionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#create LogAnalyticsSolution#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#delete LogAnalyticsSolution#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#read LogAnalyticsSolution#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#update LogAnalyticsSolution#update}
    */
    readonly update?: string;
}
export declare function logAnalyticsSolutionTimeoutsToTerraform(struct?: LogAnalyticsSolutionTimeoutsOutputReference | LogAnalyticsSolutionTimeouts | cdktf.IResolvable): any;
export declare class LogAnalyticsSolutionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogAnalyticsSolutionTimeouts | undefined;
    set internalValue(value: LogAnalyticsSolutionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution azurerm_log_analytics_solution}
*/
export declare class LogAnalyticsSolution extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution azurerm_log_analytics_solution} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogAnalyticsSolutionConfig
    */
    constructor(scope: Construct, id: string, config: LogAnalyticsSolutionConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _solutionName?;
    get solutionName(): string;
    set solutionName(value: string);
    get solutionNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceName?;
    get workspaceName(): string;
    set workspaceName(value: string);
    get workspaceNameInput(): string | undefined;
    private _workspaceResourceId?;
    get workspaceResourceId(): string;
    set workspaceResourceId(value: string);
    get workspaceResourceIdInput(): string | undefined;
    private _plan;
    get plan(): LogAnalyticsSolutionPlanOutputReference;
    putPlan(value: LogAnalyticsSolutionPlan): void;
    get planInput(): LogAnalyticsSolutionPlan | undefined;
    private _timeouts;
    get timeouts(): LogAnalyticsSolutionTimeoutsOutputReference;
    putTimeouts(value: LogAnalyticsSolutionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogAnalyticsSolutionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
