import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#maximum_bytes_per_packet NetworkPacketCapture#maximum_bytes_per_packet}
    */
    readonly maximumBytesPerPacket?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#maximum_bytes_per_session NetworkPacketCapture#maximum_bytes_per_session}
    */
    readonly maximumBytesPerSession?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#maximum_capture_duration NetworkPacketCapture#maximum_capture_duration}
    */
    readonly maximumCaptureDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#name NetworkPacketCapture#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#network_watcher_name NetworkPacketCapture#network_watcher_name}
    */
    readonly networkWatcherName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#resource_group_name NetworkPacketCapture#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#target_resource_id NetworkPacketCapture#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#filter NetworkPacketCapture#filter}
    */
    readonly filter?: NetworkPacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#storage_location NetworkPacketCapture#storage_location}
    */
    readonly storageLocation: NetworkPacketCaptureStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#timeouts NetworkPacketCapture#timeouts}
    */
    readonly timeouts?: NetworkPacketCaptureTimeouts;
}
export interface NetworkPacketCaptureFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#local_ip_address NetworkPacketCapture#local_ip_address}
    */
    readonly localIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#local_port NetworkPacketCapture#local_port}
    */
    readonly localPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#protocol NetworkPacketCapture#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#remote_ip_address NetworkPacketCapture#remote_ip_address}
    */
    readonly remoteIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#remote_port NetworkPacketCapture#remote_port}
    */
    readonly remotePort?: string;
}
export declare function networkPacketCaptureFilterToTerraform(struct?: NetworkPacketCaptureFilter | cdktf.IResolvable): any;
export interface NetworkPacketCaptureStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#file_path NetworkPacketCapture#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#storage_account_id NetworkPacketCapture#storage_account_id}
    */
    readonly storageAccountId?: string;
}
export declare function networkPacketCaptureStorageLocationToTerraform(struct?: NetworkPacketCaptureStorageLocationOutputReference | NetworkPacketCaptureStorageLocation): any;
export declare class NetworkPacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NetworkPacketCaptureStorageLocation | undefined;
    set internalValue(value: NetworkPacketCaptureStorageLocation | undefined);
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    get storagePath(): string;
}
export interface NetworkPacketCaptureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#create NetworkPacketCapture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#delete NetworkPacketCapture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#read NetworkPacketCapture#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture#update NetworkPacketCapture#update}
    */
    readonly update?: string;
}
export declare function networkPacketCaptureTimeoutsToTerraform(struct?: NetworkPacketCaptureTimeoutsOutputReference | NetworkPacketCaptureTimeouts | cdktf.IResolvable): any;
export declare class NetworkPacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NetworkPacketCaptureTimeouts | undefined;
    set internalValue(value: NetworkPacketCaptureTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture azurerm_network_packet_capture}
*/
export declare class NetworkPacketCapture extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture azurerm_network_packet_capture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPacketCaptureConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPacketCaptureConfig);
    get id(): string;
    private _maximumBytesPerPacket?;
    get maximumBytesPerPacket(): number;
    set maximumBytesPerPacket(value: number);
    resetMaximumBytesPerPacket(): void;
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    get maximumBytesPerSession(): number;
    set maximumBytesPerSession(value: number);
    resetMaximumBytesPerSession(): void;
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDuration?;
    get maximumCaptureDuration(): number;
    set maximumCaptureDuration(value: number);
    resetMaximumCaptureDuration(): void;
    get maximumCaptureDurationInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherName?;
    get networkWatcherName(): string;
    set networkWatcherName(value: string);
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _filter?;
    get filter(): NetworkPacketCaptureFilter[] | cdktf.IResolvable;
    set filter(value: NetworkPacketCaptureFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | NetworkPacketCaptureFilter[] | undefined;
    private _storageLocation;
    get storageLocation(): NetworkPacketCaptureStorageLocationOutputReference;
    putStorageLocation(value: NetworkPacketCaptureStorageLocation): void;
    get storageLocationInput(): NetworkPacketCaptureStorageLocation | undefined;
    private _timeouts;
    get timeouts(): NetworkPacketCaptureTimeoutsOutputReference;
    putTimeouts(value: NetworkPacketCaptureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkPacketCaptureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
