import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#assignable_scopes RoleDefinition#assignable_scopes}
    */
    readonly assignableScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#description RoleDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#name RoleDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#role_definition_id RoleDefinition#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#scope RoleDefinition#scope}
    */
    readonly scope: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#permissions RoleDefinition#permissions}
    */
    readonly permissions?: RoleDefinitionPermissions[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#timeouts RoleDefinition#timeouts}
    */
    readonly timeouts?: RoleDefinitionTimeouts;
}
export interface RoleDefinitionPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#actions RoleDefinition#actions}
    */
    readonly actions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#data_actions RoleDefinition#data_actions}
    */
    readonly dataActions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#not_actions RoleDefinition#not_actions}
    */
    readonly notActions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#not_data_actions RoleDefinition#not_data_actions}
    */
    readonly notDataActions?: string[];
}
export declare function roleDefinitionPermissionsToTerraform(struct?: RoleDefinitionPermissions | cdktf.IResolvable): any;
export interface RoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#create RoleDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#delete RoleDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#read RoleDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition#update RoleDefinition#update}
    */
    readonly update?: string;
}
export declare function roleDefinitionTimeoutsToTerraform(struct?: RoleDefinitionTimeoutsOutputReference | RoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class RoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RoleDefinitionTimeouts | undefined;
    set internalValue(value: RoleDefinitionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition azurerm_role_definition}
*/
export declare class RoleDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition azurerm_role_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: RoleDefinitionConfig);
    private _assignableScopes?;
    get assignableScopes(): string[];
    set assignableScopes(value: string[]);
    resetAssignableScopes(): void;
    get assignableScopesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    get roleDefinitionResourceId(): string;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _permissions?;
    get permissions(): RoleDefinitionPermissions[] | cdktf.IResolvable;
    set permissions(value: RoleDefinitionPermissions[] | cdktf.IResolvable);
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | RoleDefinitionPermissions[] | undefined;
    private _timeouts;
    get timeouts(): RoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: RoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
