import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RouteFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#location RouteFilter#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#name RouteFilter#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#resource_group_name RouteFilter#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#rule RouteFilter#rule}
    */
    readonly rule?: RouteFilterRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#tags RouteFilter#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#timeouts RouteFilter#timeouts}
    */
    readonly timeouts?: RouteFilterTimeouts;
}
export interface RouteFilterRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#access RouteFilter#access}
    */
    readonly access?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#communities RouteFilter#communities}
    */
    readonly communities?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#name RouteFilter#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#rule_type RouteFilter#rule_type}
    */
    readonly ruleType?: string;
}
export declare function routeFilterRuleToTerraform(struct?: RouteFilterRule | cdktf.IResolvable): any;
export interface RouteFilterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#create RouteFilter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#delete RouteFilter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#read RouteFilter#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter#update RouteFilter#update}
    */
    readonly update?: string;
}
export declare function routeFilterTimeoutsToTerraform(struct?: RouteFilterTimeoutsOutputReference | RouteFilterTimeouts | cdktf.IResolvable): any;
export declare class RouteFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RouteFilterTimeouts | undefined;
    set internalValue(value: RouteFilterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter azurerm_route_filter}
*/
export declare class RouteFilter extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/route_filter azurerm_route_filter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RouteFilterConfig
    */
    constructor(scope: Construct, id: string, config: RouteFilterConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    get rule(): RouteFilterRule[] | cdktf.IResolvable;
    set rule(value: RouteFilterRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | RouteFilterRule[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): RouteFilterTimeoutsOutputReference;
    putTimeouts(value: RouteFilterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RouteFilterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
