import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#auto_delete_on_idle ServicebusQueue#auto_delete_on_idle}
    */
    readonly autoDeleteOnIdle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#dead_lettering_on_message_expiration ServicebusQueue#dead_lettering_on_message_expiration}
    */
    readonly deadLetteringOnMessageExpiration?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#default_message_ttl ServicebusQueue#default_message_ttl}
    */
    readonly defaultMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#duplicate_detection_history_time_window ServicebusQueue#duplicate_detection_history_time_window}
    */
    readonly duplicateDetectionHistoryTimeWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_batched_operations ServicebusQueue#enable_batched_operations}
    */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_express ServicebusQueue#enable_express}
    */
    readonly enableExpress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#enable_partitioning ServicebusQueue#enable_partitioning}
    */
    readonly enablePartitioning?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#forward_dead_lettered_messages_to ServicebusQueue#forward_dead_lettered_messages_to}
    */
    readonly forwardDeadLetteredMessagesTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#forward_to ServicebusQueue#forward_to}
    */
    readonly forwardTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#lock_duration ServicebusQueue#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_delivery_count ServicebusQueue#max_delivery_count}
    */
    readonly maxDeliveryCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_message_size_in_kilobytes ServicebusQueue#max_message_size_in_kilobytes}
    */
    readonly maxMessageSizeInKilobytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#max_size_in_megabytes ServicebusQueue#max_size_in_megabytes}
    */
    readonly maxSizeInMegabytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#name ServicebusQueue#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#namespace_id ServicebusQueue#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#namespace_name ServicebusQueue#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#requires_duplicate_detection ServicebusQueue#requires_duplicate_detection}
    */
    readonly requiresDuplicateDetection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#requires_session ServicebusQueue#requires_session}
    */
    readonly requiresSession?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#resource_group_name ServicebusQueue#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#status ServicebusQueue#status}
    */
    readonly status?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#timeouts ServicebusQueue#timeouts}
    */
    readonly timeouts?: ServicebusQueueTimeouts;
}
export interface ServicebusQueueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#create ServicebusQueue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#delete ServicebusQueue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#read ServicebusQueue#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue#update ServicebusQueue#update}
    */
    readonly update?: string;
}
export declare function servicebusQueueTimeoutsToTerraform(struct?: ServicebusQueueTimeoutsOutputReference | ServicebusQueueTimeouts | cdktf.IResolvable): any;
export declare class ServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServicebusQueueTimeouts | undefined;
    set internalValue(value: ServicebusQueueTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue}
*/
export declare class ServicebusQueue extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusQueueConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusQueueConfig);
    private _autoDeleteOnIdle?;
    get autoDeleteOnIdle(): string;
    set autoDeleteOnIdle(value: string);
    resetAutoDeleteOnIdle(): void;
    get autoDeleteOnIdleInput(): string | undefined;
    private _deadLetteringOnMessageExpiration?;
    get deadLetteringOnMessageExpiration(): boolean | cdktf.IResolvable;
    set deadLetteringOnMessageExpiration(value: boolean | cdktf.IResolvable);
    resetDeadLetteringOnMessageExpiration(): void;
    get deadLetteringOnMessageExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    get defaultMessageTtl(): string;
    set defaultMessageTtl(value: string);
    resetDefaultMessageTtl(): void;
    get defaultMessageTtlInput(): string | undefined;
    private _duplicateDetectionHistoryTimeWindow?;
    get duplicateDetectionHistoryTimeWindow(): string;
    set duplicateDetectionHistoryTimeWindow(value: string);
    resetDuplicateDetectionHistoryTimeWindow(): void;
    get duplicateDetectionHistoryTimeWindowInput(): string | undefined;
    private _enableBatchedOperations?;
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    resetEnableBatchedOperations(): void;
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExpress?;
    get enableExpress(): boolean | cdktf.IResolvable;
    set enableExpress(value: boolean | cdktf.IResolvable);
    resetEnableExpress(): void;
    get enableExpressInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePartitioning?;
    get enablePartitioning(): boolean | cdktf.IResolvable;
    set enablePartitioning(value: boolean | cdktf.IResolvable);
    resetEnablePartitioning(): void;
    get enablePartitioningInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardDeadLetteredMessagesTo?;
    get forwardDeadLetteredMessagesTo(): string;
    set forwardDeadLetteredMessagesTo(value: string);
    resetForwardDeadLetteredMessagesTo(): void;
    get forwardDeadLetteredMessagesToInput(): string | undefined;
    private _forwardTo?;
    get forwardTo(): string;
    set forwardTo(value: string);
    resetForwardTo(): void;
    get forwardToInput(): string | undefined;
    get id(): string;
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    resetMaxDeliveryCount(): void;
    get maxDeliveryCountInput(): number | undefined;
    private _maxMessageSizeInKilobytes?;
    get maxMessageSizeInKilobytes(): number;
    set maxMessageSizeInKilobytes(value: number);
    resetMaxMessageSizeInKilobytes(): void;
    get maxMessageSizeInKilobytesInput(): number | undefined;
    private _maxSizeInMegabytes?;
    get maxSizeInMegabytes(): number;
    set maxSizeInMegabytes(value: number);
    resetMaxSizeInMegabytes(): void;
    get maxSizeInMegabytesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    private _requiresDuplicateDetection?;
    get requiresDuplicateDetection(): boolean | cdktf.IResolvable;
    set requiresDuplicateDetection(value: boolean | cdktf.IResolvable);
    resetRequiresDuplicateDetection(): void;
    get requiresDuplicateDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _requiresSession?;
    get requiresSession(): boolean | cdktf.IResolvable;
    set requiresSession(value: boolean | cdktf.IResolvable);
    resetRequiresSession(): void;
    get requiresSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicebusQueueTimeoutsOutputReference;
    putTimeouts(value: ServicebusQueueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicebusQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
