import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#auto_delete_on_idle ServicebusTopic#auto_delete_on_idle}
    */
    readonly autoDeleteOnIdle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#default_message_ttl ServicebusTopic#default_message_ttl}
    */
    readonly defaultMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#duplicate_detection_history_time_window ServicebusTopic#duplicate_detection_history_time_window}
    */
    readonly duplicateDetectionHistoryTimeWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_batched_operations ServicebusTopic#enable_batched_operations}
    */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_express ServicebusTopic#enable_express}
    */
    readonly enableExpress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_partitioning ServicebusTopic#enable_partitioning}
    */
    readonly enablePartitioning?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#max_message_size_in_kilobytes ServicebusTopic#max_message_size_in_kilobytes}
    */
    readonly maxMessageSizeInKilobytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#max_size_in_megabytes ServicebusTopic#max_size_in_megabytes}
    */
    readonly maxSizeInMegabytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#name ServicebusTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#namespace_id ServicebusTopic#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#namespace_name ServicebusTopic#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#requires_duplicate_detection ServicebusTopic#requires_duplicate_detection}
    */
    readonly requiresDuplicateDetection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#resource_group_name ServicebusTopic#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#status ServicebusTopic#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#support_ordering ServicebusTopic#support_ordering}
    */
    readonly supportOrdering?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#timeouts ServicebusTopic#timeouts}
    */
    readonly timeouts?: ServicebusTopicTimeouts;
}
export interface ServicebusTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#create ServicebusTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#delete ServicebusTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#read ServicebusTopic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#update ServicebusTopic#update}
    */
    readonly update?: string;
}
export declare function servicebusTopicTimeoutsToTerraform(struct?: ServicebusTopicTimeoutsOutputReference | ServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare class ServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServicebusTopicTimeouts | undefined;
    set internalValue(value: ServicebusTopicTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic azurerm_servicebus_topic}
*/
export declare class ServicebusTopic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic azurerm_servicebus_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusTopicConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusTopicConfig);
    private _autoDeleteOnIdle?;
    get autoDeleteOnIdle(): string;
    set autoDeleteOnIdle(value: string);
    resetAutoDeleteOnIdle(): void;
    get autoDeleteOnIdleInput(): string | undefined;
    private _defaultMessageTtl?;
    get defaultMessageTtl(): string;
    set defaultMessageTtl(value: string);
    resetDefaultMessageTtl(): void;
    get defaultMessageTtlInput(): string | undefined;
    private _duplicateDetectionHistoryTimeWindow?;
    get duplicateDetectionHistoryTimeWindow(): string;
    set duplicateDetectionHistoryTimeWindow(value: string);
    resetDuplicateDetectionHistoryTimeWindow(): void;
    get duplicateDetectionHistoryTimeWindowInput(): string | undefined;
    private _enableBatchedOperations?;
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    resetEnableBatchedOperations(): void;
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExpress?;
    get enableExpress(): boolean | cdktf.IResolvable;
    set enableExpress(value: boolean | cdktf.IResolvable);
    resetEnableExpress(): void;
    get enableExpressInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePartitioning?;
    get enablePartitioning(): boolean | cdktf.IResolvable;
    set enablePartitioning(value: boolean | cdktf.IResolvable);
    resetEnablePartitioning(): void;
    get enablePartitioningInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _maxMessageSizeInKilobytes?;
    get maxMessageSizeInKilobytes(): number;
    set maxMessageSizeInKilobytes(value: number);
    resetMaxMessageSizeInKilobytes(): void;
    get maxMessageSizeInKilobytesInput(): number | undefined;
    private _maxSizeInMegabytes?;
    get maxSizeInMegabytes(): number;
    set maxSizeInMegabytes(value: number);
    resetMaxSizeInMegabytes(): void;
    get maxSizeInMegabytesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    private _requiresDuplicateDetection?;
    get requiresDuplicateDetection(): boolean | cdktf.IResolvable;
    set requiresDuplicateDetection(value: boolean | cdktf.IResolvable);
    resetRequiresDuplicateDetection(): void;
    get requiresDuplicateDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _supportOrdering?;
    get supportOrdering(): boolean | cdktf.IResolvable;
    set supportOrdering(value: boolean | cdktf.IResolvable);
    resetSupportOrdering(): void;
    get supportOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ServicebusTopicTimeoutsOutputReference;
    putTimeouts(value: ServicebusTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicebusTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
