import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudAppRedisAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#name SpringCloudAppRedisAssociation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#redis_access_key SpringCloudAppRedisAssociation#redis_access_key}
    */
    readonly redisAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#redis_cache_id SpringCloudAppRedisAssociation#redis_cache_id}
    */
    readonly redisCacheId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#spring_cloud_app_id SpringCloudAppRedisAssociation#spring_cloud_app_id}
    */
    readonly springCloudAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#ssl_enabled SpringCloudAppRedisAssociation#ssl_enabled}
    */
    readonly sslEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#timeouts SpringCloudAppRedisAssociation#timeouts}
    */
    readonly timeouts?: SpringCloudAppRedisAssociationTimeouts;
}
export interface SpringCloudAppRedisAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#create SpringCloudAppRedisAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#delete SpringCloudAppRedisAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#read SpringCloudAppRedisAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association#update SpringCloudAppRedisAssociation#update}
    */
    readonly update?: string;
}
export declare function springCloudAppRedisAssociationTimeoutsToTerraform(struct?: SpringCloudAppRedisAssociationTimeoutsOutputReference | SpringCloudAppRedisAssociationTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudAppRedisAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudAppRedisAssociationTimeouts | undefined;
    set internalValue(value: SpringCloudAppRedisAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association azurerm_spring_cloud_app_redis_association}
*/
export declare class SpringCloudAppRedisAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_redis_association azurerm_spring_cloud_app_redis_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudAppRedisAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudAppRedisAssociationConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redisAccessKey?;
    get redisAccessKey(): string;
    set redisAccessKey(value: string);
    get redisAccessKeyInput(): string | undefined;
    private _redisCacheId?;
    get redisCacheId(): string;
    set redisCacheId(value: string);
    get redisCacheIdInput(): string | undefined;
    private _springCloudAppId?;
    get springCloudAppId(): string;
    set springCloudAppId(value: string);
    get springCloudAppIdInput(): string | undefined;
    private _sslEnabled?;
    get sslEnabled(): boolean | cdktf.IResolvable;
    set sslEnabled(value: boolean | cdktf.IResolvable);
    resetSslEnabled(): void;
    get sslEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): SpringCloudAppRedisAssociationTimeoutsOutputReference;
    putTimeouts(value: SpringCloudAppRedisAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpringCloudAppRedisAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
