import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#https_only SpringCloudApp#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#is_public SpringCloudApp#is_public}
    */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#name SpringCloudApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#resource_group_name SpringCloudApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#service_name SpringCloudApp#service_name}
    */
    readonly serviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#tls_enabled SpringCloudApp#tls_enabled}
    */
    readonly tlsEnabled?: boolean | cdktf.IResolvable;
    /**
    * custom_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#custom_persistent_disk SpringCloudApp#custom_persistent_disk}
    */
    readonly customPersistentDisk?: SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#identity SpringCloudApp#identity}
    */
    readonly identity?: SpringCloudAppIdentity;
    /**
    * persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#persistent_disk SpringCloudApp#persistent_disk}
    */
    readonly persistentDisk?: SpringCloudAppPersistentDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#timeouts SpringCloudApp#timeouts}
    */
    readonly timeouts?: SpringCloudAppTimeouts;
}
export interface SpringCloudAppCustomPersistentDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#mount_options SpringCloudApp#mount_options}
    */
    readonly mountOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#mount_path SpringCloudApp#mount_path}
    */
    readonly mountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#read_only_enabled SpringCloudApp#read_only_enabled}
    */
    readonly readOnlyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#share_name SpringCloudApp#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#storage_name SpringCloudApp#storage_name}
    */
    readonly storageName: string;
}
export declare function springCloudAppCustomPersistentDiskToTerraform(struct?: SpringCloudAppCustomPersistentDisk | cdktf.IResolvable): any;
export interface SpringCloudAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#type SpringCloudApp#type}
    */
    readonly type: string;
}
export declare function springCloudAppIdentityToTerraform(struct?: SpringCloudAppIdentityOutputReference | SpringCloudAppIdentity): any;
export declare class SpringCloudAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudAppIdentity | undefined;
    set internalValue(value: SpringCloudAppIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SpringCloudAppPersistentDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#mount_path SpringCloudApp#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#size_in_gb SpringCloudApp#size_in_gb}
    */
    readonly sizeInGb: number;
}
export declare function springCloudAppPersistentDiskToTerraform(struct?: SpringCloudAppPersistentDiskOutputReference | SpringCloudAppPersistentDisk): any;
export declare class SpringCloudAppPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudAppPersistentDisk | undefined;
    set internalValue(value: SpringCloudAppPersistentDisk | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
}
export interface SpringCloudAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#create SpringCloudApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#delete SpringCloudApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#read SpringCloudApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app#update SpringCloudApp#update}
    */
    readonly update?: string;
}
export declare function springCloudAppTimeoutsToTerraform(struct?: SpringCloudAppTimeoutsOutputReference | SpringCloudAppTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudAppTimeouts | undefined;
    set internalValue(value: SpringCloudAppTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app azurerm_spring_cloud_app}
*/
export declare class SpringCloudApp extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app azurerm_spring_cloud_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudAppConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudAppConfig);
    get fqdn(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _isPublic?;
    get isPublic(): boolean | cdktf.IResolvable;
    set isPublic(value: boolean | cdktf.IResolvable);
    resetIsPublic(): void;
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _tlsEnabled?;
    get tlsEnabled(): boolean | cdktf.IResolvable;
    set tlsEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEnabled(): void;
    get tlsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get url(): string;
    private _customPersistentDisk?;
    get customPersistentDisk(): SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable;
    set customPersistentDisk(value: SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable);
    resetCustomPersistentDisk(): void;
    get customPersistentDiskInput(): cdktf.IResolvable | SpringCloudAppCustomPersistentDisk[] | undefined;
    private _identity;
    get identity(): SpringCloudAppIdentityOutputReference;
    putIdentity(value: SpringCloudAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): SpringCloudAppIdentity | undefined;
    private _persistentDisk;
    get persistentDisk(): SpringCloudAppPersistentDiskOutputReference;
    putPersistentDisk(value: SpringCloudAppPersistentDisk): void;
    resetPersistentDisk(): void;
    get persistentDiskInput(): SpringCloudAppPersistentDisk | undefined;
    private _timeouts;
    get timeouts(): SpringCloudAppTimeoutsOutputReference;
    putTimeouts(value: SpringCloudAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpringCloudAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
