import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBlobInventoryPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#storage_account_id StorageBlobInventoryPolicy#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#storage_container_name StorageBlobInventoryPolicy#storage_container_name}
    */
    readonly storageContainerName?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#rules StorageBlobInventoryPolicy#rules}
    */
    readonly rules: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#timeouts StorageBlobInventoryPolicy#timeouts}
    */
    readonly timeouts?: StorageBlobInventoryPolicyTimeouts;
}
export interface StorageBlobInventoryPolicyRulesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#blob_types StorageBlobInventoryPolicy#blob_types}
    */
    readonly blobTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#include_blob_versions StorageBlobInventoryPolicy#include_blob_versions}
    */
    readonly includeBlobVersions?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#include_snapshots StorageBlobInventoryPolicy#include_snapshots}
    */
    readonly includeSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#prefix_match StorageBlobInventoryPolicy#prefix_match}
    */
    readonly prefixMatch?: string[];
}
export declare function storageBlobInventoryPolicyRulesFilterToTerraform(struct?: StorageBlobInventoryPolicyRulesFilterOutputReference | StorageBlobInventoryPolicyRulesFilter): any;
export declare class StorageBlobInventoryPolicyRulesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageBlobInventoryPolicyRulesFilter | undefined;
    set internalValue(value: StorageBlobInventoryPolicyRulesFilter | undefined);
    private _blobTypes?;
    get blobTypes(): string[];
    set blobTypes(value: string[]);
    get blobTypesInput(): string[] | undefined;
    private _includeBlobVersions?;
    get includeBlobVersions(): boolean | cdktf.IResolvable;
    set includeBlobVersions(value: boolean | cdktf.IResolvable);
    resetIncludeBlobVersions(): void;
    get includeBlobVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _includeSnapshots?;
    get includeSnapshots(): boolean | cdktf.IResolvable;
    set includeSnapshots(value: boolean | cdktf.IResolvable);
    resetIncludeSnapshots(): void;
    get includeSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string[];
    set prefixMatch(value: string[]);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string[] | undefined;
}
export interface StorageBlobInventoryPolicyRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#format StorageBlobInventoryPolicy#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#name StorageBlobInventoryPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#schedule StorageBlobInventoryPolicy#schedule}
    */
    readonly schedule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#schema_fields StorageBlobInventoryPolicy#schema_fields}
    */
    readonly schemaFields: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#scope StorageBlobInventoryPolicy#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#storage_container_name StorageBlobInventoryPolicy#storage_container_name}
    */
    readonly storageContainerName: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#filter StorageBlobInventoryPolicy#filter}
    */
    readonly filter?: StorageBlobInventoryPolicyRulesFilter;
}
export declare function storageBlobInventoryPolicyRulesToTerraform(struct?: StorageBlobInventoryPolicyRules | cdktf.IResolvable): any;
export interface StorageBlobInventoryPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#create StorageBlobInventoryPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#delete StorageBlobInventoryPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#read StorageBlobInventoryPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#update StorageBlobInventoryPolicy#update}
    */
    readonly update?: string;
}
export declare function storageBlobInventoryPolicyTimeoutsToTerraform(struct?: StorageBlobInventoryPolicyTimeoutsOutputReference | StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable): any;
export declare class StorageBlobInventoryPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageBlobInventoryPolicyTimeouts | undefined;
    set internalValue(value: StorageBlobInventoryPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy}
*/
export declare class StorageBlobInventoryPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBlobInventoryPolicyConfig
    */
    constructor(scope: Construct, id: string, config: StorageBlobInventoryPolicyConfig);
    get id(): string;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _storageContainerName?;
    get storageContainerName(): string;
    set storageContainerName(value: string);
    resetStorageContainerName(): void;
    get storageContainerNameInput(): string | undefined;
    private _rules?;
    get rules(): StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    set rules(value: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable);
    get rulesInput(): cdktf.IResolvable | StorageBlobInventoryPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): StorageBlobInventoryPolicyTimeoutsOutputReference;
    putTimeouts(value: StorageBlobInventoryPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageBlobInventoryPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
