import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseManagedPrivateEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#name SynapseManagedPrivateEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#subresource_name SynapseManagedPrivateEndpoint#subresource_name}
    */
    readonly subresourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#synapse_workspace_id SynapseManagedPrivateEndpoint#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#target_resource_id SynapseManagedPrivateEndpoint#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#timeouts SynapseManagedPrivateEndpoint#timeouts}
    */
    readonly timeouts?: SynapseManagedPrivateEndpointTimeouts;
}
export interface SynapseManagedPrivateEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#create SynapseManagedPrivateEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#delete SynapseManagedPrivateEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint#read SynapseManagedPrivateEndpoint#read}
    */
    readonly read?: string;
}
export declare function synapseManagedPrivateEndpointTimeoutsToTerraform(struct?: SynapseManagedPrivateEndpointTimeoutsOutputReference | SynapseManagedPrivateEndpointTimeouts | cdktf.IResolvable): any;
export declare class SynapseManagedPrivateEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SynapseManagedPrivateEndpointTimeouts | undefined;
    set internalValue(value: SynapseManagedPrivateEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint azurerm_synapse_managed_private_endpoint}
*/
export declare class SynapseManagedPrivateEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_managed_private_endpoint azurerm_synapse_managed_private_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseManagedPrivateEndpointConfig
    */
    constructor(scope: Construct, id: string, config: SynapseManagedPrivateEndpointConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subresourceName?;
    get subresourceName(): string;
    set subresourceName(value: string);
    get subresourceNameInput(): string | undefined;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SynapseManagedPrivateEndpointTimeoutsOutputReference;
    putTimeouts(value: SynapseManagedPrivateEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseManagedPrivateEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
