import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#name SynapseSqlPoolVulnerabilityAssessmentBaseline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#rule_name SynapseSqlPoolVulnerabilityAssessmentBaseline#rule_name}
    */
    readonly ruleName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#sql_pool_vulnerability_assessment_id SynapseSqlPoolVulnerabilityAssessmentBaseline#sql_pool_vulnerability_assessment_id}
    */
    readonly sqlPoolVulnerabilityAssessmentId: string;
    /**
    * baseline block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#baseline SynapseSqlPoolVulnerabilityAssessmentBaseline#baseline}
    */
    readonly baseline?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#timeouts SynapseSqlPoolVulnerabilityAssessmentBaseline#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts;
}
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#result SynapseSqlPoolVulnerabilityAssessmentBaseline#result}
    */
    readonly result: string[];
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineBaselineToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline | cdktf.IResolvable): any;
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#create SynapseSqlPoolVulnerabilityAssessmentBaseline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#delete SynapseSqlPoolVulnerabilityAssessmentBaseline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#read SynapseSqlPoolVulnerabilityAssessmentBaseline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline#update SynapseSqlPoolVulnerabilityAssessmentBaseline#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference | SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined;
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline}
*/
export declare class SynapseSqlPoolVulnerabilityAssessmentBaseline extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolVulnerabilityAssessmentBaselineConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolVulnerabilityAssessmentBaselineConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ruleName?;
    get ruleName(): string;
    set ruleName(value: string);
    get ruleNameInput(): string | undefined;
    private _sqlPoolVulnerabilityAssessmentId?;
    get sqlPoolVulnerabilityAssessmentId(): string;
    set sqlPoolVulnerabilityAssessmentId(value: string);
    get sqlPoolVulnerabilityAssessmentIdInput(): string | undefined;
    private _baseline?;
    get baseline(): SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable;
    set baseline(value: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable);
    resetBaseline(): void;
    get baselineInput(): cdktf.IResolvable | SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
