import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolWorkloadGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#importance SynapseSqlPoolWorkloadGroup#importance}
    */
    readonly importance?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#max_resource_percent SynapseSqlPoolWorkloadGroup#max_resource_percent}
    */
    readonly maxResourcePercent: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#max_resource_percent_per_request SynapseSqlPoolWorkloadGroup#max_resource_percent_per_request}
    */
    readonly maxResourcePercentPerRequest?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#min_resource_percent SynapseSqlPoolWorkloadGroup#min_resource_percent}
    */
    readonly minResourcePercent: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#min_resource_percent_per_request SynapseSqlPoolWorkloadGroup#min_resource_percent_per_request}
    */
    readonly minResourcePercentPerRequest?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#name SynapseSqlPoolWorkloadGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#query_execution_timeout_in_seconds SynapseSqlPoolWorkloadGroup#query_execution_timeout_in_seconds}
    */
    readonly queryExecutionTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#sql_pool_id SynapseSqlPoolWorkloadGroup#sql_pool_id}
    */
    readonly sqlPoolId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#timeouts SynapseSqlPoolWorkloadGroup#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolWorkloadGroupTimeouts;
}
export interface SynapseSqlPoolWorkloadGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#create SynapseSqlPoolWorkloadGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#delete SynapseSqlPoolWorkloadGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#read SynapseSqlPoolWorkloadGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group#update SynapseSqlPoolWorkloadGroup#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolWorkloadGroupTimeoutsToTerraform(struct?: SynapseSqlPoolWorkloadGroupTimeoutsOutputReference | SynapseSqlPoolWorkloadGroupTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolWorkloadGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SynapseSqlPoolWorkloadGroupTimeouts | undefined;
    set internalValue(value: SynapseSqlPoolWorkloadGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group azurerm_synapse_sql_pool_workload_group}
*/
export declare class SynapseSqlPoolWorkloadGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_group azurerm_synapse_sql_pool_workload_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolWorkloadGroupConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolWorkloadGroupConfig);
    get id(): string;
    private _importance?;
    get importance(): string;
    set importance(value: string);
    resetImportance(): void;
    get importanceInput(): string | undefined;
    private _maxResourcePercent?;
    get maxResourcePercent(): number;
    set maxResourcePercent(value: number);
    get maxResourcePercentInput(): number | undefined;
    private _maxResourcePercentPerRequest?;
    get maxResourcePercentPerRequest(): number;
    set maxResourcePercentPerRequest(value: number);
    resetMaxResourcePercentPerRequest(): void;
    get maxResourcePercentPerRequestInput(): number | undefined;
    private _minResourcePercent?;
    get minResourcePercent(): number;
    set minResourcePercent(value: number);
    get minResourcePercentInput(): number | undefined;
    private _minResourcePercentPerRequest?;
    get minResourcePercentPerRequest(): number;
    set minResourcePercentPerRequest(value: number);
    resetMinResourcePercentPerRequest(): void;
    get minResourcePercentPerRequestInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryExecutionTimeoutInSeconds?;
    get queryExecutionTimeoutInSeconds(): number;
    set queryExecutionTimeoutInSeconds(value: number);
    resetQueryExecutionTimeoutInSeconds(): void;
    get queryExecutionTimeoutInSecondsInput(): number | undefined;
    private _sqlPoolId?;
    get sqlPoolId(): string;
    set sqlPoolId(value: string);
    get sqlPoolIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolWorkloadGroupTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolWorkloadGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseSqlPoolWorkloadGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
