import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#endpoint_location TrafficManagerEndpoint#endpoint_location}
    */
    readonly endpointLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#endpoint_status TrafficManagerEndpoint#endpoint_status}
    */
    readonly endpointStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#geo_mappings TrafficManagerEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#min_child_endpoints TrafficManagerEndpoint#min_child_endpoints}
    */
    readonly minChildEndpoints?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#minimum_required_child_endpoints_ipv4 TrafficManagerEndpoint#minimum_required_child_endpoints_ipv4}
    */
    readonly minimumRequiredChildEndpointsIpv4?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#minimum_required_child_endpoints_ipv6 TrafficManagerEndpoint#minimum_required_child_endpoints_ipv6}
    */
    readonly minimumRequiredChildEndpointsIpv6?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#name TrafficManagerEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#priority TrafficManagerEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#profile_name TrafficManagerEndpoint#profile_name}
    */
    readonly profileName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#resource_group_name TrafficManagerEndpoint#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#target TrafficManagerEndpoint#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#target_resource_id TrafficManagerEndpoint#target_resource_id}
    */
    readonly targetResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#type TrafficManagerEndpoint#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#weight TrafficManagerEndpoint#weight}
    */
    readonly weight?: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#custom_header TrafficManagerEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#subnet TrafficManagerEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#timeouts TrafficManagerEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerEndpointTimeouts;
}
export interface TrafficManagerEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#name TrafficManagerEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#value TrafficManagerEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerEndpointCustomHeaderToTerraform(struct?: TrafficManagerEndpointCustomHeader | cdktf.IResolvable): any;
export interface TrafficManagerEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#first TrafficManagerEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#last TrafficManagerEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#scope TrafficManagerEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerEndpointSubnetToTerraform(struct?: TrafficManagerEndpointSubnet | cdktf.IResolvable): any;
export interface TrafficManagerEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#create TrafficManagerEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#delete TrafficManagerEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#read TrafficManagerEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#update TrafficManagerEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerEndpointTimeoutsToTerraform(struct?: TrafficManagerEndpointTimeoutsOutputReference | TrafficManagerEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TrafficManagerEndpointTimeouts | undefined;
    set internalValue(value: TrafficManagerEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint azurerm_traffic_manager_endpoint}
*/
export declare class TrafficManagerEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint azurerm_traffic_manager_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerEndpointConfig);
    private _endpointLocation?;
    get endpointLocation(): string;
    set endpointLocation(value: string);
    resetEndpointLocation(): void;
    get endpointLocationInput(): string | undefined;
    get endpointMonitorStatus(): string;
    private _endpointStatus?;
    get endpointStatus(): string;
    set endpointStatus(value: string);
    resetEndpointStatus(): void;
    get endpointStatusInput(): string | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    get id(): string;
    private _minChildEndpoints?;
    get minChildEndpoints(): number;
    set minChildEndpoints(value: number);
    resetMinChildEndpoints(): void;
    get minChildEndpointsInput(): number | undefined;
    private _minimumRequiredChildEndpointsIpv4?;
    get minimumRequiredChildEndpointsIpv4(): number;
    set minimumRequiredChildEndpointsIpv4(value: number);
    resetMinimumRequiredChildEndpointsIpv4(): void;
    get minimumRequiredChildEndpointsIpv4Input(): number | undefined;
    private _minimumRequiredChildEndpointsIpv6?;
    get minimumRequiredChildEndpointsIpv6(): number;
    set minimumRequiredChildEndpointsIpv6(value: number);
    resetMinimumRequiredChildEndpointsIpv6(): void;
    get minimumRequiredChildEndpointsIpv6Input(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileName?;
    get profileName(): string;
    set profileName(value: string);
    get profileNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    resetTargetResourceId(): void;
    get targetResourceIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _customHeader?;
    get customHeader(): TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable;
    set customHeader(value: TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable);
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerEndpointCustomHeader[] | undefined;
    private _subnet?;
    get subnet(): TrafficManagerEndpointSubnet[] | cdktf.IResolvable;
    set subnet(value: TrafficManagerEndpointSubnet[] | cdktf.IResolvable);
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): TrafficManagerEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
