import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubRouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#labels VirtualHubRouteTable#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#name VirtualHubRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#virtual_hub_id VirtualHubRouteTable#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#route VirtualHubRouteTable#route}
    */
    readonly route?: VirtualHubRouteTableRoute[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#timeouts VirtualHubRouteTable#timeouts}
    */
    readonly timeouts?: VirtualHubRouteTableTimeouts;
}
export interface VirtualHubRouteTableRoute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#destinations VirtualHubRouteTable#destinations}
    */
    readonly destinations: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#destinations_type VirtualHubRouteTable#destinations_type}
    */
    readonly destinationsType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#name VirtualHubRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#next_hop VirtualHubRouteTable#next_hop}
    */
    readonly nextHop: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#next_hop_type VirtualHubRouteTable#next_hop_type}
    */
    readonly nextHopType?: string;
}
export declare function virtualHubRouteTableRouteToTerraform(struct?: VirtualHubRouteTableRoute | cdktf.IResolvable): any;
export interface VirtualHubRouteTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#create VirtualHubRouteTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#delete VirtualHubRouteTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#read VirtualHubRouteTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table#update VirtualHubRouteTable#update}
    */
    readonly update?: string;
}
export declare function virtualHubRouteTableTimeoutsToTerraform(struct?: VirtualHubRouteTableTimeoutsOutputReference | VirtualHubRouteTableTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubRouteTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualHubRouteTableTimeouts | undefined;
    set internalValue(value: VirtualHubRouteTableTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table azurerm_virtual_hub_route_table}
*/
export declare class VirtualHubRouteTable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_route_table azurerm_virtual_hub_route_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubRouteTableConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubRouteTableConfig);
    get id(): string;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _route?;
    get route(): VirtualHubRouteTableRoute[] | cdktf.IResolvable;
    set route(value: VirtualHubRouteTableRoute[] | cdktf.IResolvable);
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | VirtualHubRouteTableRoute[] | undefined;
    private _timeouts;
    get timeouts(): VirtualHubRouteTableTimeoutsOutputReference;
    putTimeouts(value: VirtualHubRouteTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualHubRouteTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
