import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#allow_branch_to_branch_traffic VirtualWan#allow_branch_to_branch_traffic}
    */
    readonly allowBranchToBranchTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#allow_vnet_to_vnet_traffic VirtualWan#allow_vnet_to_vnet_traffic}
    */
    readonly allowVnetToVnetTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#disable_vpn_encryption VirtualWan#disable_vpn_encryption}
    */
    readonly disableVpnEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#location VirtualWan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#name VirtualWan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#office365_local_breakout_category VirtualWan#office365_local_breakout_category}
    */
    readonly office365LocalBreakoutCategory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#resource_group_name VirtualWan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#tags VirtualWan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#type VirtualWan#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#timeouts VirtualWan#timeouts}
    */
    readonly timeouts?: VirtualWanTimeouts;
}
export interface VirtualWanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#create VirtualWan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#delete VirtualWan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#read VirtualWan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan#update VirtualWan#update}
    */
    readonly update?: string;
}
export declare function virtualWanTimeoutsToTerraform(struct?: VirtualWanTimeoutsOutputReference | VirtualWanTimeouts | cdktf.IResolvable): any;
export declare class VirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualWanTimeouts | undefined;
    set internalValue(value: VirtualWanTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan azurerm_virtual_wan}
*/
export declare class VirtualWan extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_wan azurerm_virtual_wan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualWanConfig
    */
    constructor(scope: Construct, id: string, config: VirtualWanConfig);
    private _allowBranchToBranchTraffic?;
    get allowBranchToBranchTraffic(): boolean | cdktf.IResolvable;
    set allowBranchToBranchTraffic(value: boolean | cdktf.IResolvable);
    resetAllowBranchToBranchTraffic(): void;
    get allowBranchToBranchTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowVnetToVnetTraffic?;
    get allowVnetToVnetTraffic(): boolean | cdktf.IResolvable;
    set allowVnetToVnetTraffic(value: boolean | cdktf.IResolvable);
    resetAllowVnetToVnetTraffic(): void;
    get allowVnetToVnetTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _disableVpnEncryption?;
    get disableVpnEncryption(): boolean | cdktf.IResolvable;
    set disableVpnEncryption(value: boolean | cdktf.IResolvable);
    resetDisableVpnEncryption(): void;
    get disableVpnEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _office365LocalBreakoutCategory?;
    get office365LocalBreakoutCategory(): string;
    set office365LocalBreakoutCategory(value: string);
    resetOffice365LocalBreakoutCategory(): void;
    get office365LocalBreakoutCategoryInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): VirtualWanTimeoutsOutputReference;
    putTimeouts(value: VirtualWanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualWanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
