#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
This script converts multiple tif sequences into avi files using ffmpeg. You need
to install ffmpeg fitst to run this script. I use ffmpeg 3.2.2 on Windows 8.1.
Intended to work with tif sequences generated by fast-cam-record. For details, 
go to my website http://www.brain-recording.science
"""

import sys
from PyQt5.QtWidgets import (QFileDialog, QAbstractItemView, QListView,
                             QTreeView, QApplication, QDialog)
import os

class getExistingDirectories(QFileDialog):
    def __init__(self, *args):
        super(getExistingDirectories, self).__init__(*args)
        self.setOption(self.DontUseNativeDialog, True)
        self.setFileMode(self.Directory)
        self.setOption(self.ShowDirsOnly, True)
        self.setWindowTitle('Select directories that contain .tiff frames.')
        self.findChildren(QListView)[0].setSelectionMode(QAbstractItemView.ExtendedSelection)
        self.findChildren(QTreeView)[0].setSelectionMode(QAbstractItemView.ExtendedSelection)

def convert():
    qapp = QApplication(sys.argv)
    dlg = getExistingDirectories()
    if dlg.exec_() == QDialog.Accepted:
        for tifdir in dlg.selectedFiles():
            os.system("ffmpeg -i " + tifdir + "\\frame%d.tif -vcodec ffv1 " +os.path.abspath(tifdir) + ".avi")

if __name__ == "__main__":
     convert()